/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.cache.MavenArtifactCache;
import org.openrewrite.maven.tree.ResolvedDependency;

public class LocalMavenArtifactCache
implements MavenArtifactCache {
    private final Path cache;

    public LocalMavenArtifactCache(Path cache) {
        if (!cache.toFile().exists() && !cache.toFile().mkdirs()) {
            throw new IllegalStateException("Unable to find or create maven artifact cache at " + cache);
        }
        this.cache = cache;
    }

    @Override
    public @Nullable Path getArtifact(ResolvedDependency dependency) {
        Path path = this.dependencyPath(dependency);
        return path.toFile().exists() ? path : null;
    }

    @Override
    public @Nullable Path putArtifact(ResolvedDependency dependency, InputStream artifactInputStream, Consumer<Throwable> onError) {
        if (artifactInputStream == null) {
            return null;
        }
        Path path = this.dependencyPath(dependency);
        try (InputStream is = artifactInputStream;
             OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            int read;
            byte[] buffer = new byte[1024];
            while ((read = is.read(buffer, 0, 1024)) >= 0) {
                out.write(buffer, 0, read);
            }
        }
        catch (Throwable t) {
            onError.accept(t);
            return null;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path dependencyPath(ResolvedDependency dependency) {
        Path resolvedPath = this.cache.resolve(Paths.get(dependency.getGroupId().replace('.', '/'), dependency.getArtifactId(), dependency.getVersion()));
        try {
            Path path = this.cache;
            synchronized (path) {
                if (!Files.exists(resolvedPath, new LinkOption[0])) {
                    Files.createDirectories(resolvedPath, new FileAttribute[0]);
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return resolvedPath.resolve(dependency.getArtifactId() + "-" + (dependency.getDatedSnapshotVersion() == null ? dependency.getVersion() : dependency.getDatedSnapshotVersion()) + (dependency.getRequested().getClassifier() == null ? "" : dependency.getRequested().getClassifier()) + ".jar");
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalMavenArtifactCache)) {
            return false;
        }
        LocalMavenArtifactCache other = (LocalMavenArtifactCache)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Path this$cache = this.cache;
        Path other$cache = other.cache;
        return !(this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof LocalMavenArtifactCache;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Path $cache = this.cache;
        result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "LocalMavenArtifactCache(cache=" + this.cache + ")";
    }
}

