/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.BlankLinesVisitor;
import org.openrewrite.java.style.BlankLinesStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.style.Style;

public class BlankLines
extends Recipe {
    public String getDisplayName() {
        return "Blank lines";
    }

    public String getDescription() {
        return "Add and/or remove blank lines.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new BlankLinesFromCompilationUnitStyle();
    }

    public static <J2 extends J> J2 formatBlankLines(J j, Cursor cursor) {
        BlankLinesStyle style = (BlankLinesStyle)Style.from(BlankLinesStyle.class, (SourceFile)((SourceFile)cursor.firstEnclosingOrThrow(SourceFile.class)), IntelliJ::blankLines);
        return (J2)((J)new BlankLinesVisitor(style).visitNonNull(j, 0, cursor));
    }

    private static class BlankLinesFromCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private BlankLinesFromCompilationUnitStyle() {
        }

        public J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                BlankLinesStyle style = (BlankLinesStyle)Style.from(BlankLinesStyle.class, (SourceFile)cu, IntelliJ::blankLines);
                return new BlankLinesVisitor(style).visit((Tree)cu, ctx);
            }
            return (J)tree;
        }
    }
}

