/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.EmptyForInitializerPadStyle;
import org.openrewrite.java.style.EmptyForIteratorPadStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.style.Style;

public class PadEmptyForLoopComponents
extends Recipe {
    public String getDisplayName() {
        return "Pad empty `for` loop components";
    }

    public String getDescription() {
        return "Fixes padding on empty `for` loop iterators and initializers to match Checkstyle policies.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    SourceFile cu = (SourceFile)Objects.requireNonNull(tree);
                    if (Style.from(EmptyForIteratorPadStyle.class, (SourceFile)cu) != null || Style.from(EmptyForInitializerPadStyle.class, (SourceFile)cu) != null) {
                        return (J)cu.withMarkers(cu.getMarkers().add((Marker)new SearchResult(Tree.randomId(), null)));
                    }
                    return (JavaSourceFile)cu;
                }
                return (J)tree;
            }
        }, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            @Nullable EmptyForIteratorPadStyle emptyForIteratorPadStyle;
            @Nullable EmptyForInitializerPadStyle emptyForInitializerPadStyle;

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    SourceFile cu = (SourceFile)Objects.requireNonNull(tree);
                    this.emptyForInitializerPadStyle = (EmptyForInitializerPadStyle)Style.from(EmptyForInitializerPadStyle.class, (SourceFile)cu);
                    this.emptyForIteratorPadStyle = (EmptyForIteratorPadStyle)Style.from(EmptyForIteratorPadStyle.class, (SourceFile)cu);
                }
                return (J)super.visit(tree, (Object)ctx);
            }

            @Override
            public J.ForLoop visitForLoop(J.ForLoop forLoop, ExecutionContext ctx) {
                J fl = super.visitForLoop(forLoop, ctx);
                List<Statement> updates = forLoop.getControl().getUpdate();
                if (this.emptyForIteratorPadStyle != null && updates.size() == 1 && updates.get(0) instanceof J.Empty) {
                    Statement update = updates.get(0);
                    if (this.emptyForIteratorPadStyle.getSpace().booleanValue() && update.getPrefix().getWhitespace().isEmpty()) {
                        update = (Statement)update.withPrefix(update.getPrefix().withWhitespace(" "));
                    } else if (!this.emptyForIteratorPadStyle.getSpace().booleanValue() && !update.getPrefix().getWhitespace().isEmpty()) {
                        update = (Statement)update.withPrefix(update.getPrefix().withWhitespace(""));
                    }
                    fl = ((J.ForLoop)fl).withControl(((J.ForLoop)fl).getControl().withUpdate(Collections.singletonList(update)));
                }
                List init = forLoop.getControl().getInit();
                if (this.emptyForInitializerPadStyle != null && init.get(0) instanceof J.Empty) {
                    if (this.emptyForInitializerPadStyle.getSpace().booleanValue() && init.get(0).getPrefix().getWhitespace().isEmpty()) {
                        init = ListUtils.mapFirst(init, i -> (Statement)i.withPrefix(i.getPrefix().withWhitespace(" ")));
                    } else if (!this.emptyForInitializerPadStyle.getSpace().booleanValue() && !init.get(0).getPrefix().getWhitespace().isEmpty()) {
                        init = ListUtils.mapFirst((List)init, i -> (Statement)i.withPrefix(i.getPrefix().withWhitespace("")));
                    }
                    fl = ((J.ForLoop)fl).withControl(((J.ForLoop)fl).getControl().withInit(init));
                }
                return fl;
            }
        });
    }
}

