/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.modifier;

import org.openrewrite.tools.checkstyle.StatelessCheck;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.utils.ScopeUtil;

@StatelessCheck
public class ClassMemberImpliedModifierCheck
extends AbstractCheck {
    public static final String MSG_KEY = "class.implied.modifier";
    private static final String STATIC_KEYWORD = "static";
    private boolean violateImpliedStaticOnNestedEnum = true;
    private boolean violateImpliedStaticOnNestedInterface = true;
    private boolean violateImpliedStaticOnNestedRecord = true;

    public void setViolateImpliedStaticOnNestedEnum(boolean violateImplied) {
        this.violateImpliedStaticOnNestedEnum = violateImplied;
    }

    public void setViolateImpliedStaticOnNestedInterface(boolean violateImplied) {
        this.violateImpliedStaticOnNestedInterface = violateImplied;
    }

    public void setViolateImpliedStaticOnNestedRecord(boolean violateImplied) {
        this.violateImpliedStaticOnNestedRecord = violateImplied;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{15, 154, 199};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ClassMemberImpliedModifierCheck.isInTypeBlock(ast)) {
            DetailAST modifiers = ast.findFirstToken(5);
            switch (ast.getType()) {
                case 154: {
                    if (!this.violateImpliedStaticOnNestedEnum || modifiers.findFirstToken(64) != null) break;
                    this.log(ast, MSG_KEY, STATIC_KEYWORD);
                    break;
                }
                case 15: {
                    if (!this.violateImpliedStaticOnNestedInterface || modifiers.findFirstToken(64) != null) break;
                    this.log(ast, MSG_KEY, STATIC_KEYWORD);
                    break;
                }
                case 199: {
                    if (!this.violateImpliedStaticOnNestedRecord || modifiers.findFirstToken(64) != null) break;
                    this.log(ast, MSG_KEY, STATIC_KEYWORD);
                    break;
                }
                default: {
                    throw new IllegalStateException(ast.toString());
                }
            }
        }
    }

    private static boolean isInTypeBlock(DetailAST ast) {
        return ScopeUtil.isInClassBlock(ast) || ScopeUtil.isInEnumBlock(ast) || ScopeUtil.isInRecordBlock(ast);
    }
}

