/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public final class ReplaceStringLiteralValue
extends Recipe {
    @Option(displayName="Old literal `String` value", description="The `String` value to replace.", example="apple")
    private final String oldLiteralValue;
    @Option(displayName="New literal `String` value", description="The `String` value to replace with.", example="orange")
    private final String newLiteralValue;

    public String getDisplayName() {
        return "Replace `String` literal";
    }

    public String getDescription() {
        return "Replace the value of a complete `String` literal.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Literal visitLiteral(J.Literal literal, ExecutionContext ctx) {
                J lit = super.visitLiteral(literal, ctx);
                if (((J.Literal)lit).getType() == JavaType.Primitive.String && ReplaceStringLiteralValue.this.oldLiteralValue.equals(((J.Literal)lit).getValue())) {
                    return ((J.Literal)lit).withValue(ReplaceStringLiteralValue.this.newLiteralValue).withValueSource('\"' + ReplaceStringLiteralValue.this.newLiteralValue + '\"');
                }
                return lit;
            }
        };
    }

    @Generated
    public ReplaceStringLiteralValue(String oldLiteralValue, String newLiteralValue) {
        this.oldLiteralValue = oldLiteralValue;
        this.newLiteralValue = newLiteralValue;
    }

    @Generated
    public String getOldLiteralValue() {
        return this.oldLiteralValue;
    }

    @Generated
    public String getNewLiteralValue() {
        return this.newLiteralValue;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ReplaceStringLiteralValue(oldLiteralValue=" + this.getOldLiteralValue() + ", newLiteralValue=" + this.getNewLiteralValue() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplaceStringLiteralValue)) {
            return false;
        }
        ReplaceStringLiteralValue other = (ReplaceStringLiteralValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldLiteralValue = this.getOldLiteralValue();
        String other$oldLiteralValue = other.getOldLiteralValue();
        if (this$oldLiteralValue == null ? other$oldLiteralValue != null : !this$oldLiteralValue.equals(other$oldLiteralValue)) {
            return false;
        }
        String this$newLiteralValue = this.getNewLiteralValue();
        String other$newLiteralValue = other.getNewLiteralValue();
        return !(this$newLiteralValue == null ? other$newLiteralValue != null : !this$newLiteralValue.equals(other$newLiteralValue));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ReplaceStringLiteralValue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldLiteralValue = this.getOldLiteralValue();
        result = result * 59 + ($oldLiteralValue == null ? 43 : $oldLiteralValue.hashCode());
        String $newLiteralValue = this.getNewLiteralValue();
        result = result * 59 + ($newLiteralValue == null ? 43 : $newLiteralValue.hashCode());
        return result;
    }
}

