/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.lang.NonNull;
import org.xerial.snappy.Snappy;

public class JavaTypeCache
implements Cloneable {
    public static final int COMPRESSION_THRESHOLD = 50;
    Map<Object, Object> typeCache = new HashMap<Object, Object>();
    private static @Nullable boolean snappyUsable = true;

    public <T> @Nullable T get(String signature) {
        return (T)this.typeCache.get(this.key(signature));
    }

    public void put(String signature, Object o) {
        this.typeCache.put(this.key(signature), o);
    }

    private Object key(String signature) {
        if (signature.length() > 50 && snappyUsable) {
            try {
                return new BytesKey(Snappy.compress((byte[])signature.getBytes(StandardCharsets.UTF_8)));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (NoClassDefFoundError e) {
                snappyUsable = false;
            }
        }
        return signature;
    }

    public void clear() {
        this.typeCache.clear();
    }

    public int size() {
        return this.typeCache.size();
    }

    public JavaTypeCache clone() {
        try {
            JavaTypeCache clone = (JavaTypeCache)super.clone();
            clone.typeCache = new HashMap<Object, Object>(this.typeCache);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class BytesKey {
        private final byte[] data;

        @Generated
        public BytesKey(byte[] data) {
            this.data = data;
        }

        @Generated
        public byte[] getData() {
            return this.data;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BytesKey)) {
                return false;
            }
            BytesKey other = (BytesKey)o;
            return Arrays.equals(this.getData(), other.getData());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getData());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "JavaTypeCache.BytesKey(data=" + Arrays.toString(this.getData()) + ")";
        }
    }
}

