/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.SourceFile;
import org.openrewrite.SourceFileWithReferences;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.TypeMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.trait.Reference;

public class UsesType<P>
extends TreeVisitor<Tree, P> {
    private final @Nullable String fullyQualifiedType;
    private final @Nullable Predicate<JavaType> typePattern;
    private final @Nullable TypeMatcher typeMatcher;
    private final @Nullable Boolean includeImplicit;

    public UsesType(String fullyQualifiedType, @Nullable Boolean includeImplicit) {
        if (fullyQualifiedType.contains("*")) {
            int dotdot;
            this.fullyQualifiedType = null;
            this.typePattern = fullyQualifiedType.indexOf(42) == fullyQualifiedType.length() - 1 ? ((dotdot = fullyQualifiedType.indexOf("..")) == -1 && fullyQualifiedType.charAt(fullyQualifiedType.length() - 2) == '.' ? UsesType.packagePattern(fullyQualifiedType.substring(0, fullyQualifiedType.length() - 2)) : (dotdot == fullyQualifiedType.length() - 3 ? UsesType.packagePrefixPattern(fullyQualifiedType.substring(0, dotdot)) : UsesType.genericPattern(Pattern.compile(StringUtils.aspectjNameToPattern((String)fullyQualifiedType))))) : UsesType.genericPattern(Pattern.compile(StringUtils.aspectjNameToPattern((String)fullyQualifiedType)));
            this.typeMatcher = new TypeMatcher(fullyQualifiedType);
        } else {
            this.fullyQualifiedType = fullyQualifiedType;
            this.typePattern = null;
            this.typeMatcher = null;
        }
        this.includeImplicit = includeImplicit;
    }

    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof JavaSourceFile || sourceFile instanceof SourceFileWithReferences;
    }

    public @Nullable Tree visit(@Nullable Tree tree, P p) {
        TypeMatcher matcher;
        SourceFileWithReferences sourceFile;
        SourceFileWithReferences.References references;
        Iterator iterator;
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu;
            JavaSourceFile c = cu = (JavaSourceFile)Objects.requireNonNull(tree);
            for (JavaType type : c.getTypesInUse().getTypesInUse()) {
                JavaType checkType = type instanceof JavaType.Primitive ? type : TypeUtils.asFullyQualified(type);
                if ((c = this.maybeMark(c, checkType)) == cu) continue;
                return c;
            }
            for (J.Import anImport : c.getImports()) {
                if (!(anImport.isStatic() ? (c = this.maybeMark(c, TypeUtils.asFullyQualified(anImport.getQualid().getTarget().getType()))) != cu : (c = this.maybeMark(c, TypeUtils.asFullyQualified(anImport.getQualid().getType()))) != cu)) continue;
                return c;
            }
            if (Boolean.TRUE.equals(this.includeImplicit)) {
                for (JavaType.Method method : c.getTypesInUse().getUsedMethods()) {
                    if ((c = this.maybeMark(c, method.getDeclaringType())) != cu) {
                        return c;
                    }
                    if ((c = this.maybeMark(c, method.getReturnType())) != cu) {
                        return c;
                    }
                    for (JavaType parameterType : method.getParameterTypes()) {
                        if ((c = this.maybeMark(c, parameterType)) == cu) continue;
                        return c;
                    }
                }
            }
        } else if (tree instanceof SourceFileWithReferences && (iterator = (references = (sourceFile = (SourceFileWithReferences)tree).getReferences()).findMatches((Reference.Matcher)(matcher = this.typeMatcher != null ? this.typeMatcher : new TypeMatcher(this.fullyQualifiedType)), Reference.Kind.TYPE).iterator()).hasNext()) {
            Reference ignored = (Reference)iterator.next();
            return SearchResult.found((Tree)sourceFile);
        }
        return tree;
    }

    private JavaSourceFile maybeMark(JavaSourceFile c, @Nullable JavaType type) {
        if (type == null) {
            return c;
        }
        if (this.typePattern != null && TypeUtils.isAssignableTo(this.typePattern, type) || this.fullyQualifiedType != null && TypeUtils.isAssignableTo(this.fullyQualifiedType, type)) {
            return (JavaSourceFile)SearchResult.found((Tree)c);
        }
        return c;
    }

    private static Predicate<JavaType> genericPattern(Pattern pattern) {
        return type -> {
            if (type instanceof JavaType.FullyQualified) {
                return pattern.matcher(((JavaType.FullyQualified)type).getFullyQualifiedName()).matches();
            }
            if (type instanceof JavaType.Primitive) {
                return pattern.matcher(((JavaType.Primitive)type).getKeyword()).matches();
            }
            return false;
        };
    }

    private static Predicate<JavaType> packagePattern(String name) {
        return type -> type instanceof JavaType.FullyQualified && ((JavaType.FullyQualified)type).getFullyQualifiedName().startsWith(name) && ((JavaType.FullyQualified)type).getPackageName().equals(name);
    }

    private static Predicate<JavaType> packagePrefixPattern(String prefix) {
        String subPackagePrefix = prefix + ".";
        return type -> {
            if (type instanceof JavaType.FullyQualified) {
                String packageName = ((JavaType.FullyQualified)type).getPackageName();
                return packageName.equals(prefix) || packageName.startsWith(subPackagePrefix);
            }
            return false;
        };
    }

    @Generated
    public @Nullable String getFullyQualifiedType() {
        return this.fullyQualifiedType;
    }

    @Generated
    public @Nullable Predicate<JavaType> getTypePattern() {
        return this.typePattern;
    }
}

