/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@JsonIgnoreType
public class TypeMappings
extends DataTable<Row> {
    public TypeMappings(Recipe recipe) {
        super(recipe, "Type mapping", "The types mapped to J trees.");
    }

    public static final class Row {
        @Column(displayName="Source file", description="The source file that the method call occurred in.")
        private final String sourceFile;
        @Column(displayName="Tree class name", description="The class name of the tree.")
        private final String treeName;
        @Column(displayName="Java type class name", description="The class name of the java type.")
        private final String typeName;
        @Column(displayName="Java type class name", description="The class name of the java type.")
        private final Integer count;

        public Row(String sourceFile, String treeName, String typeName, Integer count) {
            this.sourceFile = sourceFile;
            this.treeName = treeName;
            this.typeName = typeName;
            this.count = count;
        }

        public String getSourceFile() {
            return this.sourceFile;
        }

        public String getTreeName() {
            return this.treeName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public Integer getCount() {
            return this.count;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            Integer this$count = this.getCount();
            Integer other$count = other.getCount();
            if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
                return false;
            }
            String this$sourceFile = this.getSourceFile();
            String other$sourceFile = other.getSourceFile();
            if (this$sourceFile == null ? other$sourceFile != null : !this$sourceFile.equals(other$sourceFile)) {
                return false;
            }
            String this$treeName = this.getTreeName();
            String other$treeName = other.getTreeName();
            if (this$treeName == null ? other$treeName != null : !this$treeName.equals(other$treeName)) {
                return false;
            }
            String this$typeName = this.getTypeName();
            String other$typeName = other.getTypeName();
            return !(this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $count = this.getCount();
            result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
            String $sourceFile = this.getSourceFile();
            result = result * 59 + ($sourceFile == null ? 43 : $sourceFile.hashCode());
            String $treeName = this.getTreeName();
            result = result * 59 + ($treeName == null ? 43 : $treeName.hashCode());
            String $typeName = this.getTypeName();
            result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "TypeMappings.Row(sourceFile=" + this.getSourceFile() + ", treeName=" + this.getTreeName() + ", typeName=" + this.getTypeName() + ", count=" + this.getCount() + ")";
        }
    }
}

