/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.service;

import java.util.Collections;
import java.util.List;
import org.openrewrite.Incubating;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.tree.J;

@Incubating(since="8.12.0")
public class AnnotationService {
    public boolean matches(J j, AnnotationMatcher matcher) {
        for (J.Annotation annotation : this.getAllAnnotations(j)) {
            if (!matcher.matches(annotation)) continue;
            return true;
        }
        return false;
    }

    public List<J.Annotation> getAllAnnotations(J j) {
        if (j instanceof J.VariableDeclarations) {
            return ((J.VariableDeclarations)j).getAllAnnotations();
        }
        if (j instanceof J.AnnotatedType) {
            return ((J.AnnotatedType)j).getAllAnnotations();
        }
        if (j instanceof J.MethodDeclaration) {
            return ((J.MethodDeclaration)j).getAllAnnotations();
        }
        if (j instanceof J.ClassDeclaration) {
            return ((J.ClassDeclaration)j).getAllAnnotations();
        }
        if (j instanceof J.TypeParameter) {
            return ((J.TypeParameter)j).getAnnotations();
        }
        if (j instanceof J.TypeParameters) {
            return ((J.TypeParameters)j).getAnnotations();
        }
        if (j instanceof J.Package) {
            return ((J.Package)j).getAnnotations();
        }
        return Collections.emptyList();
    }
}

