/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.FindReferencedTypes;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;

public class DeleteStatement<P>
extends JavaIsoVisitor<P> {
    private final Statement statement;

    public DeleteStatement(Statement statement) {
        this.statement = statement;
    }

    @Override
    @Nullable
    public Statement visitStatement(Statement statement, P p) {
        J s = super.visitStatement(statement, (Object)p);
        if (!(this.getCursor().getParentOrThrow().getValue() instanceof SourceFile)) {
            return s;
        }
        if (this.statement.isScope(s)) {
            return s instanceof J.Block ? this.emptyBlock() : null;
        }
        return s;
    }

    @Override
    public J.If visitIf(J.If iff, P p) {
        J i = super.visitIf(iff, (Object)p);
        if (this.statement.isScope(((J.If)i).getThenPart())) {
            i = ((J.If)i).withThenPart(this.emptyBlock());
        } else if (((J.If)i).getElsePart() != null && this.statement.isScope(((J.If)i).getElsePart().getBody())) {
            i = ((J.If)i).withElsePart(((J.If)i).getElsePart().withBody(this.emptyBlock()));
        }
        return i;
    }

    @Override
    public J.ForLoop visitForLoop(J.ForLoop forLoop, P p) {
        return this.statement.isScope(forLoop.getBody()) ? forLoop.withBody(this.emptyBlock()) : super.visitForLoop(forLoop, (Object)p);
    }

    @Override
    public J.ForLoop.Control visitForControl(J.ForLoop.Control control, P p) {
        return control;
    }

    @Override
    public J.ForEachLoop visitForEachLoop(J.ForEachLoop forEachLoop, P p) {
        return this.statement.isScope(forEachLoop.getBody()) ? forEachLoop.withBody(this.emptyBlock()) : super.visitForEachLoop(forEachLoop, (Object)p);
    }

    @Override
    public J.ForEachLoop.Control visitForEachControl(J.ForEachLoop.Control control, P p) {
        return control;
    }

    @Override
    public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, P p) {
        return this.statement.isScope(whileLoop.getBody()) ? whileLoop.withBody(this.emptyBlock()) : super.visitWhileLoop(whileLoop, (Object)p);
    }

    @Override
    public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, P p) {
        return this.statement.isScope(doWhileLoop.getBody()) ? doWhileLoop.withBody(this.emptyBlock()) : super.visitDoWhileLoop(doWhileLoop, (Object)p);
    }

    @Override
    public J.Block visitBlock(J.Block block, P p) {
        J b = super.visitBlock(block, (Object)p);
        return ((J.Block)b).withStatements(ListUtils.map(((J.Block)b).getStatements(), s -> this.statement.isScope((Tree)s) ? null : s));
    }

    public J preVisit(J tree, P p) {
        if (this.statement.isScope(tree)) {
            for (JavaType.FullyQualified referenced : FindReferencedTypes.find(tree)) {
                this.maybeRemoveImport(referenced);
            }
        }
        return (J)super.preVisit((Tree)tree, p);
    }

    private Statement emptyBlock() {
        return J.Block.createEmptyBlock();
    }
}

