/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collections;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class ChangeFieldName<P>
extends JavaIsoVisitor<P> {
    private final String classType;
    private final String hasName;
    private final String toName;

    @Override
    public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, P p) {
        J.VariableDeclarations.NamedVariable v = variable;
        J.ClassDeclaration enclosingClass = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
        if (enclosingClass == null) {
            return v;
        }
        if (variable.isField(this.getCursor()) && this.matchesClass(enclosingClass.getType()) && variable.getSimpleName().equals(this.hasName)) {
            v = v.withName(v.getName().withSimpleName(this.toName));
        }
        if (variable.getPadding().getInitializer() != null) {
            v = v.getPadding().withInitializer(this.visitLeftPadded(variable.getPadding().getInitializer(), JLeftPadded.Location.VARIABLE_INITIALIZER, p));
        }
        return v;
    }

    @Override
    public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, P p) {
        J f = super.visitFieldAccess(fieldAccess, (Object)p);
        if (this.matchesClass(fieldAccess.getTarget().getType()) && fieldAccess.getSimpleName().equals(this.hasName)) {
            f = ((J.FieldAccess)f).getPadding().withName(((J.FieldAccess)f).getPadding().getName().withElement(((J.FieldAccess)f).getPadding().getName().getElement().withSimpleName(this.toName)));
        }
        return f;
    }

    @Override
    public J.Identifier visitIdentifier(J.Identifier ident, P p) {
        JavaType.Variable varType;
        J i = super.visitIdentifier(ident, (Object)p);
        if (((J.Identifier)i).getFieldType() != null && (varType = ((J.Identifier)i).getFieldType()).getName().equals(this.hasName) && TypeUtils.isOfClassType(varType.getOwner(), this.classType)) {
            if (varType.getOwner() instanceof JavaType.Method) {
                return i;
            }
            i = new J.Identifier(Tree.randomId(), ((J.Identifier)i).getPrefix(), ((J.Identifier)i).getMarkers(), Collections.emptyList(), this.toName, ((J.Identifier)i).getType(), new JavaType.Variable(null, Flag.flagsToBitMap(varType.getFlags()), this.toName, varType.getOwner(), varType.getType(), varType.getAnnotations()));
        }
        return i;
    }

    private boolean matchesClass(@Nullable JavaType test) {
        JavaType.FullyQualified testClassType = TypeUtils.asFullyQualified(test);
        return testClassType != null && testClassType.getFullyQualifiedName().equals(this.classType);
    }

    public ChangeFieldName(String classType, String hasName, String toName) {
        this.classType = classType;
        this.hasName = hasName;
        this.toName = toName;
    }

    public String getClassType() {
        return this.classType;
    }

    public String getHasName() {
        return this.hasName;
    }

    public String getToName() {
        return this.toName;
    }

    @NonNull
    public String toString() {
        return "ChangeFieldName(classType=" + this.getClassType() + ", hasName=" + this.getHasName() + ", toName=" + this.getToName() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeFieldName)) {
            return false;
        }
        ChangeFieldName other = (ChangeFieldName)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$classType = this.getClassType();
        String other$classType = other.getClassType();
        if (this$classType == null ? other$classType != null : !this$classType.equals(other$classType)) {
            return false;
        }
        String this$hasName = this.getHasName();
        String other$hasName = other.getHasName();
        if (this$hasName == null ? other$hasName != null : !this$hasName.equals(other$hasName)) {
            return false;
        }
        String this$toName = this.getToName();
        String other$toName = other.getToName();
        return !(this$toName == null ? other$toName != null : !this$toName.equals(other$toName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeFieldName;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $classType = this.getClassType();
        result = result * 59 + ($classType == null ? 43 : $classType.hashCode());
        String $hasName = this.getHasName();
        result = result * 59 + ($hasName == null ? 43 : $hasName.hashCode());
        String $toName = this.getToName();
        result = result * 59 + ($toName == null ? 43 : $toName.hashCode());
        return result;
    }
}

