/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dataflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.dataflow.Dataflow;
import org.openrewrite.java.dataflow.LocalFlowSpec;
import org.openrewrite.java.dataflow.analysis.SinkFlow;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

@Incubating(since="7.24.0")
public class FindLocalFlowPaths
extends JavaIsoVisitor<ExecutionContext> {
    private static final String FLOW_GRAPHS = "flowGraphs";
    private final LocalFlowSpec<?, ?> spec;

    @Override
    public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext ctx) {
        this.getCursor().putMessage(FLOW_GRAPHS, new ArrayList());
        J c = super.visitJavaSourceFile(cu, ctx);
        final Set flowSteps = Collections.newSetFromMap(new IdentityHashMap());
        List sinkFlows = (List)this.getCursor().getMessage(FLOW_GRAPHS);
        for (SinkFlow flowGraph : Objects.requireNonNull(sinkFlows)) {
            for (List<Cursor> flow : flowGraph.getFlows()) {
                for (Cursor step : flow) {
                    flowSteps.add((Expression)step.getValue());
                }
            }
        }
        if (!flowSteps.isEmpty()) {
            this.doAfterVisit(new JavaIsoVisitor<ExecutionContext>(){

                @Override
                public Expression visitExpression(Expression expression, ExecutionContext ctx) {
                    return flowSteps.contains(expression) ? (Expression)expression.withMarkers(expression.getMarkers().searchResult()) : expression;
                }
            });
        }
        return c;
    }

    @Override
    public Expression visitExpression(Expression expression, ExecutionContext ctx) {
        Dataflow.startingAt(this.getCursor()).findSinks(this.spec).ifPresent(flow -> {
            if (flow.isNotEmpty()) {
                List flowGraphs = (List)this.getCursor().getNearestMessage(FLOW_GRAPHS);
                assert (flowGraphs != null);
                flowGraphs.add(flow);
            }
        });
        return expression;
    }

    public FindLocalFlowPaths(LocalFlowSpec<?, ?> spec) {
        this.spec = spec;
    }
}

