/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public class UseStandardCharset
extends Recipe {
    public String getDisplayName() {
        return "Use `StandardCharset` constants";
    }

    public String getDescription() {
        return "Replaces `Charset.forName(java.lang.String)` with the equivalent `StandardCharset` constant.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType<ExecutionContext>("java.nio.charset.Charset");
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new UseStandardCharsetVisitor();
    }

    private static class UseStandardCharsetVisitor
    extends JavaVisitor<ExecutionContext> {
        MethodMatcher CHARSET_FOR_NAME = new MethodMatcher("java.nio.charset.Charset forName(java.lang.String)");
        Map<String, String> charsetValueToCode = new HashMap<String, String>();

        public UseStandardCharsetVisitor() {
            this.charsetValueToCode.put("US-ASCII", "StandardCharsets.US_ASCII");
            this.charsetValueToCode.put("ISO-8859-1", "StandardCharsets.ISO_8859_1");
            this.charsetValueToCode.put("UTF-8", "StandardCharsets.UTF_8");
            this.charsetValueToCode.put("UTF-16", "StandardCharsets.UTF_16");
            this.charsetValueToCode.put("UTF-16BE", "StandardCharsets.UTF_16BE");
            this.charsetValueToCode.put("UTF-16LE", "StandardCharsets.UTF_16LE");
        }

        @Override
        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
            String maybeReplace;
            J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, executionContext);
            if (this.CHARSET_FOR_NAME.matches(m) && this.charsetValueToCode.containsKey(maybeReplace = (String)((J.Literal)m.getArguments().get(0)).getValue())) {
                this.maybeAddImport("java.nio.charset.StandardCharsets");
                return m.withTemplate(JavaTemplate.builder(() -> ((UseStandardCharsetVisitor)this).getCursor(), this.charsetValueToCode.get(maybeReplace)).imports("java.nio.charset.StandardCharsets").build(), m.getCoordinates().replace(), new Object[0]);
            }
            return m;
        }
    }
}

