/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class BigDecimalRoundingConstantsToEnums
extends Recipe {
    private static final MethodMatcher BIG_DECIMAL_DIVIDE = new MethodMatcher("java.math.BigDecimal divide(java.math.BigDecimal, int)");
    private static final MethodMatcher BIG_DECIMAL_DIVIDE_WITH_SCALE = new MethodMatcher("java.math.BigDecimal divide(java.math.BigDecimal, int, int)");
    private static final MethodMatcher BIG_DECIMAL_SET_SCALE = new MethodMatcher("java.math.BigDecimal setScale(int, int)");

    public String getDisplayName() {
        return "`BigDecimal` rounding constants to `RoundingMode` enums";
    }

    public String getDescription() {
        return "Convert `BigDecimal` rounding constants to the equivalent `RoundingMode` enum.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-2111");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected JavaVisitor<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType<ExecutionContext>("java.math.BigDecimal");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            private final JavaTemplate twoArgDivide = JavaTemplate.builder(() -> (this).getCursor(), "#{any(java.math.BigDecimal)}, #{}").imports("java.math.RoundingMode").build();
            private final JavaTemplate twoArgScale = JavaTemplate.builder(() -> (this).getCursor(), "#{any(int)}, #{}").imports("java.math.RoundingMode").build();
            private final JavaTemplate threeArg = JavaTemplate.builder(() -> (this).getCursor(), "#{any(java.math.BigDecimal)}, #{any(int)}, #{}").imports("java.math.RoundingMode").build();

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J m = super.visitMethodInvocation(method, executionContext);
                if (BIG_DECIMAL_DIVIDE.matches((J.MethodInvocation)m) && this.isConvertibleBigDecimalConstant(((J.MethodInvocation)m).getArguments().get(1))) {
                    String roundingModeEnum = this.getTemplateText(((J.MethodInvocation)m).getArguments().get(1));
                    if (roundingModeEnum == null) {
                        return m;
                    }
                    m = (J.MethodInvocation)m.withTemplate(this.twoArgDivide, ((J.MethodInvocation)m).getCoordinates().replaceArguments(), ((J.MethodInvocation)m).getArguments().get(0), roundingModeEnum);
                    this.maybeAddImport("java.math.RoundingMode");
                } else if (BIG_DECIMAL_SET_SCALE.matches((J.MethodInvocation)m) && this.isConvertibleBigDecimalConstant(((J.MethodInvocation)m).getArguments().get(1))) {
                    String roundingModeEnum = this.getTemplateText(((J.MethodInvocation)m).getArguments().get(1));
                    if (roundingModeEnum == null) {
                        return m;
                    }
                    m = (J.MethodInvocation)m.withTemplate(this.twoArgScale, ((J.MethodInvocation)m).getCoordinates().replaceArguments(), ((J.MethodInvocation)m).getArguments().get(0), roundingModeEnum);
                    this.maybeAddImport("java.math.RoundingMode");
                } else if (BIG_DECIMAL_DIVIDE_WITH_SCALE.matches((J.MethodInvocation)m) && this.isConvertibleBigDecimalConstant(((J.MethodInvocation)m).getArguments().get(2))) {
                    String roundingModeEnum = this.getTemplateText(((J.MethodInvocation)m).getArguments().get(2));
                    if (roundingModeEnum == null) {
                        return m;
                    }
                    m = (J.MethodInvocation)m.withTemplate(this.threeArg, ((J.MethodInvocation)m).getCoordinates().replaceArguments(), ((J.MethodInvocation)m).getArguments().get(0), ((J.MethodInvocation)m).getArguments().get(1), roundingModeEnum);
                    this.maybeAddImport("java.math.RoundingMode");
                }
                return m;
            }

            private boolean isConvertibleBigDecimalConstant(J elem) {
                if (elem instanceof J.Literal) {
                    return true;
                }
                if (elem instanceof J.FieldAccess && ((J.FieldAccess)elem).getTarget().getType() instanceof JavaType.FullyQualified) {
                    J.FieldAccess fa = (J.FieldAccess)elem;
                    return fa.getTarget().getType() != null && TypeUtils.isOfClassType(fa.getTarget().getType(), "java.math.BigDecimal");
                }
                return false;
            }

            @Nullable
            private String getTemplateText(J elem) {
                String roundingName = null;
                if (elem instanceof J.FieldAccess && ((J.FieldAccess)elem).getTarget().getType() instanceof JavaType.FullyQualified) {
                    J.FieldAccess fa = (J.FieldAccess)elem;
                    if (fa.getTarget().getType() != null && TypeUtils.isOfClassType(fa.getTarget().getType(), "java.math.BigDecimal")) {
                        roundingName = fa.getSimpleName();
                    }
                } else if (elem instanceof J.Literal) {
                    roundingName = ((J.Literal)elem).getValueSource();
                }
                if (roundingName != null) {
                    switch (roundingName) {
                        case "ROUND_UP": 
                        case "0": {
                            return "RoundingMode.UP";
                        }
                        case "ROUND_DOWN": 
                        case "1": {
                            return "RoundingMode.DOWN";
                        }
                        case "ROUND_CEILING": 
                        case "2": {
                            return "RoundingMode.CEILING";
                        }
                        case "ROUND_FLOOR": 
                        case "3": {
                            return "RoundingMode.FLOOR";
                        }
                        case "ROUND_HALF_UP": 
                        case "4": {
                            return "RoundingMode.HALF_UP";
                        }
                        case "ROUND_HALF_DOWN": 
                        case "5": {
                            return "RoundingMode.HALF_DOWN";
                        }
                        case "ROUND_HALF_EVEN": 
                        case "6": {
                            return "RoundingMode.HALF_EVEN";
                        }
                        case "ROUND_UNNECESSARY": 
                        case "7": {
                            return "RoundingMode.UNNECESSARY";
                        }
                    }
                }
                return null;
            }
        };
    }
}

