/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.search;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.trait.GradleDependency;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.tree.J;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class FindDependency
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate identifying its publisher.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate uniquely identifying it among artifacts from the same publisher.", example="guava")
    private final String artifactId;
    @Option(displayName="Dependency configuration", description="The dependency configuration to search for dependencies in. If omitted then all configurations will be searched.", example="api", required=false)
    private final @Nullable String configuration;
    @Option(displayName="Version", description="An exact version number or node-style semver selector used to select the version number.", example="3.0.0", required=false)
    private final @Nullable String version;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;

    public String getDisplayName() {
        return "Find Gradle dependency";
    }

    public String getInstanceNameSuffix() {
        String maybeVersionSuffix = this.version == null ? "" : String.format(":%s%s", this.version, this.versionPattern == null ? "" : this.versionPattern);
        return String.format("`%s:%s%s`", this.groupId, this.artifactId, maybeVersionSuffix);
    }

    public String getDescription() {
        return "Finds dependencies declared in gradle build files. See the [reference](https://docs.gradle.org/current/userguide/java_library_plugin.html#sec:java_library_configurations_graph) on Gradle configurations or the diagram below for a description of what configuration to use. A project's compile and runtime classpath is based on these configurations.\n\n<img alt=\"Gradle compile classpath\" src=\"https://docs.gradle.org/current/userguide/img/java-library-ignore-deprecated-main.png\" width=\"200px\"/>\nA project's test classpath is based on these configurations.\n\n<img alt=\"Gradle test classpath\" src=\"https://docs.gradle.org/current/userguide/img/java-library-ignore-deprecated-test.png\" width=\"200px\"/>.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new GradleDependency.Matcher().groupId(this.groupId).artifactId(this.artifactId).configuration(this.configuration).asVisitor(gd -> FindDependency.versionIsValid(this.version, this.versionPattern, gd) ? SearchResult.found((Tree)((J.MethodInvocation)gd.getTree())) : gd.getTree());
    }

    private static boolean versionIsValid(@Nullable String desiredVersion, @Nullable String versionPattern, GradleDependency gradleDependency) {
        if (desiredVersion == null) {
            return true;
        }
        String actualVersion = gradleDependency.getDeclaredVersion();
        if (actualVersion == null) {
            return false;
        }
        Validated validate = Semver.validate((String)desiredVersion, (String)versionPattern);
        if (validate.isInvalid()) {
            return false;
        }
        assert (validate.getValue() != null);
        return ((VersionComparator)validate.getValue()).isValid(actualVersion, actualVersion);
    }

    @Generated
    public FindDependency(String groupId, String artifactId, @Nullable String configuration, @Nullable String version, @Nullable String versionPattern) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.configuration = configuration;
        this.version = version;
        this.versionPattern = versionPattern;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public @Nullable String getConfiguration() {
        return this.configuration;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindDependency(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", configuration=" + this.getConfiguration() + ", version=" + this.getVersion() + ", versionPattern=" + this.getVersionPattern() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindDependency)) {
            return false;
        }
        FindDependency other = (FindDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

