/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.style;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.java.style.Autodetect;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

public class Autodetect
extends NamedStyles {
    @JsonCreator
    public Autodetect(UUID id, Collection<Style> styles) {
        super(id, "org.openrewrite.gradle.Autodetect", "Auto-detected", "Automatically detect styles from a repository's existing code.", Collections.emptySet(), styles);
    }

    public static Detector detector() {
        return new Detector();
    }

    public static class Detector {
        Autodetect.Detector javaDetector = new Autodetect.Detector();

        public void sample(SourceFile cu) {
            if (cu instanceof G.CompilationUnit) {
                this.javaDetector.sampleJava((JavaSourceFile)((G.CompilationUnit)cu));
            }
        }

        public Autodetect build() {
            return new Autodetect(Tree.randomId(), Arrays.asList(this.javaDetector.getTabsAndIndentsStyle(), this.javaDetector.getImportLayoutStyle(), this.javaDetector.getSpacesStyle(), this.javaDetector.getWrappingAndBracesStyle(), this.javaDetector.getFormatStyle()));
        }
    }
}

