/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.groovy.GroovyParser;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.J;

public class GradleParser
implements Parser<G.CompilationUnit> {
    private static final byte[] PREAMBLE = StringUtils.readFully((InputStream)GroovyParser.class.getResourceAsStream("/RewriteGradleProject.groovy")).trim().replaceAll("\\n}}$", "").getBytes(StandardCharsets.UTF_8);
    private GroovyParser groovyParser;

    public GradleParser(GroovyParser.Builder groovyParser) {
        try {
            this.groovyParser = groovyParser.classpath(new String[]{"gradle-core-api", "gradle-language-groovy", "gradle-language-java", "gradle-resources", "gradle-testing-base", "gradle-testing-jvm"}).build();
        }
        catch (IllegalArgumentException e) {
            this.groovyParser = groovyParser.build();
        }
    }

    public List<G.CompilationUnit> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        Iterable gradleWrapped = StreamSupport.stream(sources.spliterator(), false).map(source -> new Parser.Input(source.getPath(), source.getFileAttributes(), () -> new SequenceInputStream(Collections.enumeration(Arrays.asList(new ByteArrayInputStream(PREAMBLE), source.getSource(), new ByteArrayInputStream(new byte[]{125, 125})))), source.isSynthetic())).collect(Collectors.toList());
        return this.groovyParser.parseInputs(gradleWrapped, relativeTo, ctx).stream().map(cu -> {
            List projectBody = ((J.ClassDeclaration)cu.getClasses().get(cu.getClasses().size() - 1)).getBody().getStatements();
            J.MethodDeclaration script = (J.MethodDeclaration)projectBody.get(projectBody.size() - 1);
            assert (script.getBody() != null);
            return cu.withStatements(script.getBody().getStatements());
        }).collect(Collectors.toList());
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".gradle");
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("build.gradle");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Parser.Builder {
        protected GroovyParser.Builder groovyParser = GroovyParser.builder();

        public Builder() {
            super(G.CompilationUnit.class);
        }

        public GradleParser build() {
            return new GradleParser(this.groovyParser);
        }

        public String getDslName() {
            return "gradle";
        }

        @NonNull
        public Builder setGroovyParser(GroovyParser.Builder groovyParser) {
            this.groovyParser = groovyParser;
            return this;
        }

        public GroovyParser.Builder getGroovyParser() {
            return this.groovyParser;
        }
    }
}

