/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.time.Duration;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.semver.DependencyMatcher;

public final class ChangeDependencyConfiguration
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="New configuration", description="A dependency configuration container.", example="api")
    private final String newConfiguration;
    @Option(displayName="Dependency configuration", description="The dependency configuration to search for dependencies in.", example="api", required=false)
    @Nullable
    private final String configuration;

    public String getDisplayName() {
        return "Change a Gradle dependency configuration";
    }

    public String getDescription() {
        return "Finds dependencies declared in `build.gradle` files.";
    }

    public Validated validate() {
        return super.validate().and(DependencyMatcher.build((String)(this.groupId + ":" + this.artifactId)));
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new IsBuildGradle();
    }

    public GroovyVisitor<ExecutionContext> getVisitor() {
        return new GroovyVisitor<ExecutionContext>(){
            final DependencyMatcher depMatcher;
            final MethodMatcher dependencyDsl;
            {
                this.depMatcher = (DependencyMatcher)DependencyMatcher.build((String)(ChangeDependencyConfiguration.this.groupId + ":" + ChangeDependencyConfiguration.this.artifactId)).getValue();
                this.dependencyDsl = new MethodMatcher("DependencyHandlerSpec *(..)");
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)context);
                if (!this.dependencyDsl.matches(m) || ChangeDependencyConfiguration.this.configuration != null && !ChangeDependencyConfiguration.this.configuration.isEmpty() && !m.getSimpleName().equals(ChangeDependencyConfiguration.this.configuration)) {
                    return m;
                }
                if (!ChangeDependencyConfiguration.this.newConfiguration.equals(m.getSimpleName())) {
                    m = m.withName(m.getName().withSimpleName(ChangeDependencyConfiguration.this.newConfiguration));
                }
                return m;
            }
        };
    }

    public ChangeDependencyConfiguration(String groupId, String artifactId, String newConfiguration, @Nullable String configuration) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newConfiguration = newConfiguration;
        this.configuration = configuration;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getNewConfiguration() {
        return this.newConfiguration;
    }

    @Nullable
    public String getConfiguration() {
        return this.configuration;
    }

    @NonNull
    public String toString() {
        return "ChangeDependencyConfiguration(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newConfiguration=" + this.getNewConfiguration() + ", configuration=" + this.getConfiguration() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeDependencyConfiguration)) {
            return false;
        }
        ChangeDependencyConfiguration other = (ChangeDependencyConfiguration)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newConfiguration = this.getNewConfiguration();
        String other$newConfiguration = other.getNewConfiguration();
        if (this$newConfiguration == null ? other$newConfiguration != null : !this$newConfiguration.equals(other$newConfiguration)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeDependencyConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newConfiguration = this.getNewConfiguration();
        result = result * 59 + ($newConfiguration == null ? 43 : $newConfiguration.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }
}

