/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileType;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.recomp.AbstractRecompilationSpecProvider;
import org.gradle.api.internal.tasks.compile.incremental.recomp.CurrentCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.GroovyIncrementalCompileResult;
import org.gradle.api.internal.tasks.compile.incremental.recomp.GroovySourceFileClassNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.recomp.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileChangeProcessor;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Factory;
import org.gradle.internal.FileUtils;
import org.gradle.internal.file.Deleter;
import org.gradle.work.FileChange;
import org.gradle.workers.internal.DefaultWorkResult;

public class GroovyRecompilationSpecProvider
extends AbstractRecompilationSpecProvider {
    private final boolean incremental;
    private final Iterable<FileChange> sourceChanges;
    private final GroovySourceFileClassNameConverter sourceFileClassNameConverter;

    public GroovyRecompilationSpecProvider(Deleter deleter, FileOperations fileOperations, FileTree sources, boolean incremental, Iterable<FileChange> sourceChanges, GroovySourceFileClassNameConverter sourceFileClassNameConverter) {
        super(deleter, fileOperations, sources);
        this.incremental = incremental;
        this.sourceChanges = sourceChanges;
        this.sourceFileClassNameConverter = sourceFileClassNameConverter;
    }

    @Override
    public boolean isIncremental() {
        return this.incremental;
    }

    @Override
    public RecompilationSpec provideRecompilationSpec(CurrentCompilation current, PreviousCompilation previous) {
        RecompilationSpec spec = new RecompilationSpec();
        if (this.sourceFileClassNameConverter.isEmpty()) {
            spec.setFullRebuildCause("unable to get source-classes mapping relationship from last compilation", null);
            return spec;
        }
        this.processClasspathChanges(current, previous, spec);
        this.processOtherChanges(previous, spec);
        spec.getClassesToProcess().addAll(previous.getTypesToReprocess());
        return spec;
    }

    @Override
    public boolean initializeCompilation(JavaCompileSpec spec, RecompilationSpec recompilationSpec) {
        if (!recompilationSpec.isBuildNeeded()) {
            spec.setSourceFiles(Collections.emptySet());
            spec.setClasses(Collections.emptySet());
            return false;
        }
        Factory patternSetFactory = this.fileOperations.getFileResolver().getPatternSetFactory();
        PatternSet classesToDelete = (PatternSet)patternSetFactory.create();
        PatternSet filesToRecompile = (PatternSet)patternSetFactory.create();
        this.prepareFilePatterns(recompilationSpec.getRelativeSourcePathsToCompile(), classesToDelete, filesToRecompile);
        spec.setSourceFiles(this.sourceTree.matching(filesToRecompile));
        this.includePreviousCompilationOutputOnClasspath(spec);
        this.addClassesToProcess(spec, recompilationSpec);
        return this.deleteStaleFilesIn(classesToDelete, spec.getDestinationDir());
    }

    @Override
    public WorkResult decorateResult(RecompilationSpec recompilationSpec, WorkResult workResult) {
        if (!recompilationSpec.isFullRebuildNeeded()) {
            return new GroovyIncrementalCompileResult((DefaultWorkResult)workResult);
        }
        return workResult;
    }

    private void prepareFilePatterns(Set<String> relativeSourcePathsToCompile, PatternSet classesToDelete, PatternSet filesToRecompilePatterns) {
        for (String relativeSourcePath : relativeSourcePathsToCompile) {
            filesToRecompilePatterns.include(relativeSourcePath);
            this.sourceFileClassNameConverter.getClassNames(relativeSourcePath).stream().map(staleClass -> staleClass.replaceAll("\\.", "/").concat(".class")).forEach(xva$0 -> classesToDelete.include((String)xva$0));
        }
    }

    private void processOtherChanges(PreviousCompilation previous, RecompilationSpec spec) {
        if (spec.isFullRebuildNeeded()) {
            return;
        }
        SourceFileChangeProcessor sourceFileChangeProcessor = new SourceFileChangeProcessor(previous);
        for (FileChange fileChange : this.sourceChanges) {
            if (spec.isFullRebuildNeeded()) {
                return;
            }
            if (fileChange.getFileType() != FileType.FILE) continue;
            File changedFile = fileChange.getFile();
            if (!FileUtils.hasExtension(changedFile, ".groovy")) {
                spec.setFullRebuildCause(this.rebuildClauseForChangedNonSourceFile("non-Groovy file", fileChange), null);
                return;
            }
            String relativeFilePath = fileChange.getNormalizedPath();
            Collection<String> changedClasses = this.sourceFileClassNameConverter.getClassNames(relativeFilePath);
            spec.getRelativeSourcePathsToCompile().add(relativeFilePath);
            sourceFileChangeProcessor.processChange(changedFile, changedClasses, spec);
        }
        for (String className : spec.getClassesToCompile()) {
            if (spec.isFullRebuildNeeded()) {
                return;
            }
            Optional<String> relativeSourceFile = this.sourceFileClassNameConverter.getRelativeSourcePath(className);
            if (relativeSourceFile.isPresent()) {
                spec.getRelativeSourcePathsToCompile().add(relativeSourceFile.get());
                continue;
            }
            spec.setFullRebuildCause("unable to find source file of class " + className, null);
        }
    }
}

