/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rpc.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ObjectMappers;

public class PreparedRecipeCache {
    private static final ObjectMapper mapper = ObjectMappers.propertyBasedMapper(null);
    private final Map<String, Recipe> instantiated = new HashMap<String, Recipe>();
    private final Map<Recipe, Cursor> recipeCursors = new IdentityHashMap<Recipe, Cursor>();

    public <P> TreeVisitor<?, P> instantiateVisitor(String visitorName, @Nullable Map<String, Object> visitorOptions) {
        if (visitorName.startsWith("scan:")) {
            final ScanningRecipe recipe = (ScanningRecipe)this.instantiated.get(visitorName.substring("scan:".length()));
            return new TreeVisitor<Tree, ExecutionContext>(){

                @Override
                public Tree preVisit(@NonNull Tree tree, ExecutionContext ctx) {
                    this.stopAfterPreVisit();
                    Object acc = recipe.getAccumulator(PreparedRecipeCache.this.recipeCursors.computeIfAbsent(recipe, r -> new Cursor(null, "root")), ctx);
                    recipe.getScanner(acc).visit(tree, ctx);
                    return tree;
                }
            };
        }
        if (visitorName.startsWith("edit:")) {
            Recipe recipe = this.instantiated.get(visitorName.substring("edit:".length()));
            return recipe.getVisitor();
        }
        HashMap<String, String> withJsonType = visitorOptions == null ? new HashMap<String, String>() : new HashMap<String, Object>(visitorOptions);
        withJsonType.put("@c", visitorName);
        try {
            Class visitorType = TypeFactory.defaultInstance().findClass(visitorName);
            return (TreeVisitor)mapper.convertValue(withJsonType, visitorType);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public Map<String, Recipe> getInstantiated() {
        return this.instantiated;
    }

    @Generated
    public Map<Recipe, Cursor> getRecipeCursors() {
        return this.recipeCursors;
    }
}

