/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.rpc;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.moderne.jsonrpc.JsonRpc;
import io.moderne.jsonrpc.formatter.JsonMessageFormatter;
import io.moderne.jsonrpc.formatter.MessageFormatter;
import io.moderne.jsonrpc.handler.HeaderDelimitedMessageHandler;
import io.moderne.jsonrpc.handler.MessageHandler;
import io.moderne.jsonrpc.handler.TraceMessageHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.StringUtils;

public class RewriteRpcProcess
extends Thread {
    private final String[] command;
    private boolean trace;
    private @Nullable Process process;
    private JsonRpc rpcClient;
    private final Map<String, String> environment = new LinkedHashMap<String, String>();

    public RewriteRpcProcess(String ... command) {
        this.command = command;
        this.setName("JavaScriptRewriteRpcProcess");
        this.setDaemon(false);
    }

    public Map<String, String> environment() {
        return this.environment;
    }

    public RewriteRpcProcess trace() {
        this.trace = true;
        return this;
    }

    @Override
    public void run() {
        try {
            ProcessBuilder pb = new ProcessBuilder(this.command);
            pb.environment().putAll(this.environment);
            this.process = pb.start();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public @Nullable RuntimeException getLivenessCheck() {
        if (this.process != null && !this.process.isAlive()) {
            int exitCode = this.process.exitValue();
            String errorOutput = "";
            String stdOutput = "";
            try (InputStream errorStream2 = this.process.getErrorStream();
                 InputStream inputStream = this.process.getInputStream();){
                errorOutput = StringUtils.readFully(errorStream2);
                stdOutput = StringUtils.readFully(inputStream);
            }
            catch (IOException | UnsupportedOperationException errorStream2) {
                // empty catch block
            }
            String message = "JavaScript RPC process shut down early with exit code " + exitCode;
            if (!stdOutput.isEmpty()) {
                message = message + "\nStandard output:\n  " + stdOutput.replace("\n", "\n  ");
            }
            if (!errorOutput.isEmpty()) {
                message = message + "\nError output:\n  " + errorOutput.replace("\n", "\n  ");
            }
            return new IllegalStateException(message.trim());
        }
        return null;
    }

    @Override
    public synchronized void start() {
        super.start();
        while (this.process == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        SimpleModule module = new SimpleModule();
        module.addSerializer(Path.class, (JsonSerializer)new PathSerializer());
        module.addDeserializer(Path.class, (JsonDeserializer)new PathDeserializer());
        JsonMessageFormatter formatter = new JsonMessageFormatter(new Module[]{module});
        HeaderDelimitedMessageHandler handler = new HeaderDelimitedMessageHandler((MessageFormatter)formatter, this.process.getInputStream(), this.process.getOutputStream());
        if (this.trace) {
            handler = new TraceMessageHandler("client", (MessageHandler)handler);
        }
        this.rpcClient = new JsonRpc((MessageHandler)handler);
    }

    public void shutdown() {
        if (this.process != null && this.process.isAlive()) {
            this.process.destroy();
            try {
                int exitCode;
                boolean exited = this.process.waitFor(5L, TimeUnit.SECONDS);
                if (!exited) {
                    this.process.destroyForcibly();
                    this.process.waitFor(2L, TimeUnit.SECONDS);
                }
                if ((exitCode = this.process.exitValue()) != 0 && exitCode != 143) {
                    throw new RuntimeException("JavaScript Rewrite RPC process crashed with exit code: " + exitCode);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Generated
    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    @Generated
    public JsonRpc getRpcClient() {
        return this.rpcClient;
    }

    private static class PathSerializer
    extends JsonSerializer<Path> {
        private PathSerializer() {
        }

        public void serialize(Path path, JsonGenerator g, SerializerProvider serializerProvider) throws IOException {
            g.writeString(path.toString());
        }
    }

    private static class PathDeserializer
    extends JsonDeserializer<Path> {
        private PathDeserializer() {
        }

        public Path deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String pathString = p.getValueAsString();
            return Paths.get(pathString, new String[0]);
        }
    }
}

