/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.config.ColumnDescriptor;
import org.openrewrite.config.DataTableDescriptor;
import org.openrewrite.config.RecipeIntrospectionException;
import org.openrewrite.internal.ReflectionUtils;

public class RecipeIntrospectionUtils {
    public static TreeVisitor<?, ExecutionContext> recipeVisitor(Recipe recipe) {
        try {
            Method getVisitor = ReflectionUtils.findMethod(recipe.getClass(), "getVisitor", new Class[0]);
            if (getVisitor == null) {
                throw new RecipeIntrospectionException("Recipe " + recipe.getName() + " does not implement getVisitor()");
            }
            getVisitor.setAccessible(true);
            return (TreeVisitor)getVisitor.invoke((Object)recipe, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException t) {
            throw new RecipeIntrospectionException("Unable to invoke getVisitor() on " + recipe.getClass().getName(), t);
        }
    }

    public static List<SourceFile> recipeVisit(Recipe recipe, List<SourceFile> before, ExecutionContext ctx) {
        try {
            Method visit = ReflectionUtils.findMethod(recipe.getClass(), "visit", List.class, ExecutionContext.class);
            if (visit == null) {
                throw new RecipeIntrospectionException("Recipe " + recipe.getClass().getName() + " does not implement visit(List<SourceFile>, ExecutionContext)");
            }
            visit.setAccessible(true);
            return (List)visit.invoke((Object)recipe, before, ctx);
        }
        catch (IllegalAccessException | InvocationTargetException t) {
            throw new RecipeIntrospectionException("Unable to invoke visit(List<SourceFile>, ExecutionContext) on " + recipe.getClass().getName(), t);
        }
    }

    public static DataTableDescriptor dataTableDescriptorFromDataTable(DataTable<?> dataTable) {
        return new DataTableDescriptor(dataTable.getName(), dataTable.getDisplayName(), dataTable.getDescription(), RecipeIntrospectionUtils.getColumnDescriptors(dataTable));
    }

    public static Constructor<?> getPrimaryConstructor(Class<?> recipeClass) {
        Constructor<?>[] constructors = recipeClass.getConstructors();
        if (constructors.length == 0) {
            throw new RecipeIntrospectionException("Unable to locate primary constructor for Recipe " + recipeClass);
        }
        if (recipeClass.getConstructors().length == 1) {
            return recipeClass.getConstructors()[0];
        }
        Constructor<?> constructor = RecipeIntrospectionUtils.findJsonCreator(constructors);
        if (constructor != null) {
            return constructor;
        }
        throw new RecipeIntrospectionException("Unable to locate primary constructor for Recipe " + recipeClass);
    }

    private static @Nullable Constructor<?> findJsonCreator(Constructor<?>[] constructors) {
        for (Constructor<?> constructor : constructors) {
            for (Annotation annotation : constructor.getAnnotations()) {
                if (!"com.fasterxml.jackson.annotation.JsonCreator".equals(annotation.annotationType().getName())) continue;
                return constructor;
            }
        }
        return null;
    }

    public static @Nullable Constructor<?> getZeroArgsConstructor(Class<?> recipeClass) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = recipeClass.getConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            return constructor;
        }
        return null;
    }

    public static Recipe constructRecipe(Class<?> recipeClass) {
        return (Recipe)RecipeIntrospectionUtils.construct(recipeClass, null);
    }

    public static Recipe constructRecipe(Class<?> recipeClass, Map<String, Object> args) {
        return (Recipe)RecipeIntrospectionUtils.construct(recipeClass, args);
    }

    private static <V> V construct(Class<?> clazz, @Nullable Map<String, Object> args) {
        Constructor<?> constructor = RecipeIntrospectionUtils.getConstructor(clazz, args);
        Object[] constructorArgs = new Object[constructor.getParameterCount()];
        for (int i = 0; i < constructor.getParameters().length; ++i) {
            Parameter param = constructor.getParameters()[i];
            if (args != null && args.containsKey(param.getName())) {
                constructorArgs[i] = RecipeIntrospectionUtils.convert(args.get(param.getName()), param.getType());
                continue;
            }
            if (param.getType().isPrimitive()) {
                constructorArgs[i] = RecipeIntrospectionUtils.getPrimitiveDefault(param.getType());
                continue;
            }
            if (Enum.class.isAssignableFrom(param.getType()) && args == null) {
                try {
                    Object[] values = (Object[])param.getType().getMethod("values", new Class[0]).invoke(null, new Object[0]);
                    constructorArgs[i] = values[0];
                    continue;
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            constructorArgs[i] = List.class.isAssignableFrom(param.getType()) && args == null ? Collections.emptyList() : null;
        }
        constructor.setAccessible(true);
        try {
            return (V)constructor.newInstance(constructorArgs);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw RecipeIntrospectionUtils.getRecipeIntrospectionException(clazz, e);
        }
    }

    private static Constructor<?> getConstructor(Class<?> clazz, @Nullable Map<String, Object> args) {
        if (RecipeIntrospectionUtils.isKotlin(clazz)) {
            throw new RecipeIntrospectionException("Kotlin recipes must be instantiated using Jackson");
        }
        if (args == null || args.isEmpty()) {
            Constructor<?> constructor = RecipeIntrospectionUtils.getZeroArgsConstructor(clazz);
            if (constructor != null) {
                return constructor;
            }
            return RecipeIntrospectionUtils.getPrimaryConstructor(clazz);
        }
        Constructor<?>[] constructors = clazz.getConstructors();
        Constructor<?> jsonCreator = RecipeIntrospectionUtils.findJsonCreator(constructors);
        if (jsonCreator != null) {
            return jsonCreator;
        }
        int argCount = args.size();
        block0: for (Constructor<?> constructor : constructors) {
            if (constructor.getParameterCount() < argCount) continue;
            for (int i = 0; i < constructor.getParameterCount(); ++i) {
                Class<?> paramType;
                Parameter param = constructor.getParameters()[i];
                if (!args.containsKey(param.getName()) || !(paramType = RecipeIntrospectionUtils.getParamType(param)).isInstance(args.get(param.getName()))) continue block0;
            }
            return constructor;
        }
        throw new RecipeIntrospectionException("Unable to locate matching constructor for Recipe " + clazz.getName());
    }

    private static Class<?> getParamType(Parameter param) {
        return param.getType().isPrimitive() ? RecipeIntrospectionUtils.getWrapperType(param.getType()) : param.getType();
    }

    private static Class<?> getWrapperType(Class<?> primitiveType) {
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        if (primitiveType == Void.TYPE) {
            return Void.class;
        }
        return primitiveType;
    }

    private static Object convert(Object o, Class<?> type) {
        if (type == String.class) {
            return Objects.toString(o, null);
        }
        if (o instanceof String && type.isEnum()) {
            ?[] values;
            for (Object value : values = type.getEnumConstants()) {
                if (!value.toString().equalsIgnoreCase((String)o)) continue;
                return value;
            }
        }
        return o;
    }

    private static boolean isKotlin(Class<?> clazz) {
        for (Annotation a : clazz.getDeclaredAnnotations()) {
            if (!"kotlin.Metadata".equals(a.annotationType().getName())) continue;
            return true;
        }
        return false;
    }

    private static RecipeIntrospectionException getRecipeIntrospectionException(Class<?> recipeClass, ReflectiveOperationException e) {
        return new RecipeIntrospectionException("Unable to call primary constructor for Recipe " + recipeClass, e);
    }

    private static List<ColumnDescriptor> getColumnDescriptors(DataTable<?> dataTable) {
        ArrayList<ColumnDescriptor> columns = new ArrayList<ColumnDescriptor>();
        for (Field field : dataTable.getType().getDeclaredFields()) {
            field.setAccessible(true);
            Column column = field.getAnnotation(Column.class);
            if (column == null) continue;
            columns.add(new ColumnDescriptor(field.getName(), field.getType().getSimpleName(), column.displayName(), column.description()));
        }
        return columns;
    }

    private static Object getPrimitiveDefault(Class<?> t) {
        if (t.equals(Byte.TYPE)) {
            return (byte)0;
        }
        if (t.equals(Short.TYPE)) {
            return (short)0;
        }
        if (t.equals(Integer.TYPE)) {
            return 0;
        }
        if (t.equals(Long.TYPE)) {
            return 0L;
        }
        if (t.equals(Float.TYPE)) {
            return Float.valueOf(0.0f);
        }
        if (t.equals(Double.TYPE)) {
            return 0.0;
        }
        if (t.equals(Character.TYPE)) {
            return Character.valueOf('\u0000');
        }
        if (t.equals(Boolean.TYPE)) {
            return false;
        }
        throw new RecipeIntrospectionException(t.getCanonicalName() + " is not a supported primitive type");
    }
}

