/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;

public class ReflectionUtils {
    private static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    private static final Map<Class<?>, Method[]> DECLARED_METHODS_CACHE = new ConcurrentHashMap(256);

    public static boolean isClassAvailable(String fullyQualifiedClassName) {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader classLoader = contextClassLoader == null ? ReflectionUtils.class.getClassLoader() : contextClassLoader;
            Class.forName(fullyQualifiedClassName, false, classLoader);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static @Nullable Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : ReflectionUtils.getDeclaredMethods(searchType)) {
                if (!name.equals(method.getName()) || !ReflectionUtils.hasSameParams(method, paramTypes)) continue;
                return method;
            }
        }
        return null;
    }

    public static List<Path> findClassPathEntriesFor(String resourceName, ClassLoader classLoader) {
        ArrayList<Path> classPathEntries = new ArrayList<Path>();
        try {
            Enumeration<URL> resources = classLoader.getResources(resourceName);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                if (resource.getProtocol().equals("jar") && resource.getPath().startsWith("file:")) {
                    classPathEntries.add(Paths.get(URI.create(resource.getPath().substring(0, resource.getPath().indexOf("!")))));
                    continue;
                }
                if (!resource.getProtocol().equals("file")) continue;
                classPathEntries.add(Paths.get(resource.getPath().substring(0, resource.getPath().indexOf(resourceName)), new String[0]));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return classPathEntries;
    }

    private static Method[] getDeclaredMethods(Class<?> clazz) {
        Method[] result = DECLARED_METHODS_CACHE.get(clazz);
        if (result == null) {
            try {
                Method[] declaredMethods = clazz.getDeclaredMethods();
                List<Method> defaultMethods = ReflectionUtils.findConcreteMethodsOnInterfaces(clazz);
                if (defaultMethods != null) {
                    result = new Method[declaredMethods.length + defaultMethods.size()];
                    System.arraycopy(declaredMethods, 0, result, 0, declaredMethods.length);
                    int index = declaredMethods.length;
                    Iterator<Method> iterator = defaultMethods.iterator();
                    while (iterator.hasNext()) {
                        Method defaultMethod;
                        result[index] = defaultMethod = iterator.next();
                        ++index;
                    }
                } else {
                    result = declaredMethods;
                }
                DECLARED_METHODS_CACHE.put(clazz, result.length == 0 ? EMPTY_METHOD_ARRAY : result);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", ex);
            }
        }
        return result;
    }

    private static @Nullable List<Method> findConcreteMethodsOnInterfaces(Class<?> clazz) {
        ArrayList<Method> result = null;
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method ifcMethod : ifc.getMethods()) {
                if (Modifier.isAbstract(ifcMethod.getModifiers())) continue;
                if (result == null) {
                    result = new ArrayList<Method>();
                }
                result.add(ifcMethod);
            }
        }
        return result;
    }

    private static boolean hasSameParams(Method method, Class<?>[] paramTypes) {
        return paramTypes.length == method.getParameterCount() && Arrays.equals(paramTypes, method.getParameterTypes());
    }
}

