/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.openrewrite.remote.RemoteArtifactCache;

public class LocalRemoteArtifactCache
implements RemoteArtifactCache {
    private final Path cacheDir;

    public LocalRemoteArtifactCache(Path cacheDir) {
        if (!cacheDir.toFile().exists() && !cacheDir.toFile().mkdirs()) {
            throw new IllegalStateException("Unable to find or create remote archive cache at " + cacheDir);
        }
        this.cacheDir = cacheDir;
    }

    @Override
    public @Nullable Path get(URI uri) {
        Path resolved = this.cacheDir.resolve(LocalRemoteArtifactCache.hashUri(uri));
        return Files.exists(resolved, new LinkOption[0]) ? resolved : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public @Nullable Path put(URI uri, InputStream artifactInputStream, Consumer<Throwable> onError) {
        LocalRemoteArtifactCache localRemoteArtifactCache = this;
        synchronized (localRemoteArtifactCache) {
            Path path;
            InputStream is;
            Path artifact;
            block25: {
                artifact = this.cacheDir.resolve(UUID.randomUUID() + ".tmp");
                is = artifactInputStream;
                Files.copy(is, artifact, StandardCopyOption.REPLACE_EXISTING);
                Path cachedArtifact = this.cacheDir.resolve(LocalRemoteArtifactCache.hashUri(uri));
                if (!Files.exists(cachedArtifact, new LinkOption[0])) {
                    Files.move(artifact, cachedArtifact, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                }
                path = cachedArtifact;
                if (is == null) break block25;
                is.close();
            }
            if (Files.exists(artifact, new LinkOption[0])) {
                try {
                    Files.delete(artifact);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return path;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            onError.accept(e);
                            Path path2 = null;
                            if (Files.exists(artifact, new LinkOption[0])) {
                                try {
                                    Files.delete(artifact);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            return path2;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (Files.exists(artifact, new LinkOption[0])) {
                            try {
                                Files.delete(artifact);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable3;
                    }
                }
            }
        }
    }

    public static String hashUri(URI uri) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(uri.toString().getBytes(StandardCharsets.UTF_8));
            StringBuilder hashStringBuilder = new StringBuilder();
            for (byte hashByte : hashBytes) {
                String hex = Integer.toHexString(0xFF & hashByte);
                if (hex.length() == 1) {
                    hashStringBuilder.append('0');
                }
                hashStringBuilder.append(hex);
            }
            return hashStringBuilder.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

