/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.CursorValidatingExecutionContextView;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeObserver;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.RecipeRunException;
import org.openrewrite.internal.TreeVisitorAdapter;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public abstract class TreeVisitor<T extends @Nullable Tree, P> {
    private static final String STOP_AFTER_PRE_VISIT = "__org.openrewrite.stopVisitor__";
    Cursor cursor = new Cursor(null, "root");
    private @Nullable List<TreeVisitor<?, P>> afterVisit;
    private int visitCount;
    private final DistributionSummary visitCountSummary = DistributionSummary.builder((String)"rewrite.visitor.visit.method.count").description("Visit methods called per source file visited.").tag("visitor.class", this.getClass().getName()).register((MeterRegistry)Metrics.globalRegistry);

    public static <T extends Tree, P> TreeVisitor<T, P> noop() {
        return new TreeVisitor<T, P>(){

            @Override
            public @Nullable T visit(@Nullable Tree tree, P p) {
                return tree;
            }

            @Override
            public @Nullable T visit(@Nullable Tree tree, P p, Cursor parent) {
                return tree;
            }
        };
    }

    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return true;
    }

    public void setCursor(@Nullable Cursor cursor) {
        assert (cursor != null);
        this.cursor = cursor;
    }

    public @Nullable String getLanguage() {
        return null;
    }

    protected void doAfterVisit(TreeVisitor<?, P> visitor) {
        if (this.afterVisit == null) {
            this.afterVisit = new ArrayList(2);
        }
        this.afterVisit.add(visitor);
    }

    protected List<TreeVisitor<?, P>> getAfterVisit() {
        return this.afterVisit == null ? Collections.emptyList() : this.afterVisit;
    }

    public final Cursor getCursor() {
        return this.cursor;
    }

    public final Cursor updateCursor(T currentValue) {
        Object old = this.cursor.getValue();
        if (!(old instanceof Tree)) {
            throw new IllegalArgumentException("To update the cursor, it must currently be positioned at a Tree instance");
        }
        if (!((Tree)old).getId().equals(((Tree)Objects.requireNonNull(currentValue)).getId())) {
            throw new IllegalArgumentException("Updating the cursor in place is only supported for mutations on a Tree instance that maintain the same ID after the mutation.");
        }
        this.cursor = new Cursor(this.cursor.getParentOrThrow(), currentValue);
        return this.cursor;
    }

    public @Nullable T preVisit(@NonNull T tree, P p) {
        return this.defaultValue((Tree)tree, p);
    }

    public @Nullable T postVisit(@NonNull T tree, P p) {
        return this.defaultValue((Tree)tree, p);
    }

    public @Nullable T visit(@Nullable Tree tree, P p, Cursor parent) {
        assert (!(parent.getValue() instanceof Tree && ((Tree)parent.getValue()).isScope(tree) && p instanceof ExecutionContext && CursorValidatingExecutionContextView.view((ExecutionContext)p).getValidateCursorAcyclic())) : "The `parent` cursor must not point to the same `tree` as the tree to be visited. This usually indicates that you have used getCursor() where getCursor().getParent() is appropriate. This is a test-only validation which can be opted out of by configuring your test's type validation options with `cursorAcyclic(false)`.";
        this.cursor = parent;
        return this.visit(tree, p);
    }

    public @NonNull T visitNonNull(Tree tree, P p) {
        T t = this.visit(tree, p);
        assert (t != null);
        return t;
    }

    public @NonNull T visitNonNull(Tree tree, P p, Cursor parent) {
        T t = this.visit(tree, p, parent);
        assert (t != null);
        return t;
    }

    @Incubating(since="7.31.0")
    public static <R extends Tree, C extends Collection<R>> C collect(TreeVisitor<?, ExecutionContext> visitor, Tree tree, C initial) {
        return TreeVisitor.collect(visitor, tree, initial, Tree.class, t -> t);
    }

    @Incubating(since="7.31.0")
    public static <U extends Tree, R, C extends Collection<R>> C collect(TreeVisitor<?, ExecutionContext> visitor, Tree tree, final C initial, final Class<U> matchOn, final Function<U, R> map) {
        InMemoryExecutionContext ctx = new InMemoryExecutionContext();
        ctx.addObserver(new TreeObserver.Subscription(new TreeObserver(){

            @Override
            public Tree treeChanged(Cursor cursor, Tree newTree) {
                initial.add(map.apply((Tree)matchOn.cast(newTree)));
                return newTree;
            }
        }).subscribeToType(matchOn));
        visitor.visit(tree, (ExecutionContext)ctx);
        return initial;
    }

    @Incubating(since="7.31.0")
    public P reduce(Iterable<? extends Tree> trees, P p) {
        for (Tree tree : trees) {
            this.visit(tree, p);
        }
        return p;
    }

    @Incubating(since="7.31.0")
    public P reduce(Tree tree, P p) {
        this.visit(tree, p);
        return p;
    }

    @Incubating(since="7.31.0")
    public P reduce(Tree tree, P p, Cursor parent) {
        this.visit(tree, p, parent);
        return p;
    }

    public @Nullable T visit(@Nullable Tree tree, P p) {
        if (tree == null) {
            return this.defaultValue(null, p);
        }
        Timer.Sample sample = null;
        boolean topLevel = false;
        if (this.visitCount == 0) {
            topLevel = true;
            sample = Timer.start();
        }
        ++this.visitCount;
        this.setCursor(new Cursor(this.cursor, tree));
        Tree t = null;
        boolean isAcceptable = tree.isAcceptable(this, p) && (!(tree instanceof SourceFile) || this.isAcceptable((SourceFile)tree, p));
        try {
            if (isAcceptable) {
                t = this.preVisit(tree, p);
                if (!this.cursor.getMessage(STOP_AFTER_PRE_VISIT, false).booleanValue()) {
                    if (t != null) {
                        t = t.accept(this, p);
                    }
                    if (t != null) {
                        t = this.postVisit(t, p);
                    }
                }
                if (t != tree && t != null && p instanceof ExecutionContext) {
                    ExecutionContext ctx = (ExecutionContext)p;
                    for (TreeObserver.Subscription observer : ctx.getObservers()) {
                        if (!observer.isSubscribed(tree)) continue;
                        t = observer.treeChanged(this.getCursor(), t, tree);
                    }
                }
            }
            this.setCursor(this.cursor.getParent());
            if (topLevel) {
                sample.stop(Timer.builder((String)"rewrite.visitor.visit").tag("visitor.class", this.getClass().getName()).register((MeterRegistry)Metrics.globalRegistry));
                this.visitCountSummary.record((double)this.visitCount);
                if (t != null && this.afterVisit != null) {
                    for (TreeVisitor treeVisitor : this.afterVisit) {
                        treeVisitor.setCursor(this.getCursor());
                        t = treeVisitor.visit(t, p);
                    }
                }
                sample.stop(Timer.builder((String)"rewrite.visitor.visit.cumulative").tag("visitor.class", this.getClass().getName()).register((MeterRegistry)Metrics.globalRegistry));
                this.afterVisit = null;
                this.visitCount = 0;
            }
        }
        catch (Throwable e) {
            if (e instanceof RecipeRunException) {
                throw e;
            }
            throw new RecipeRunException(e, this.getCursor());
        }
        return (T)(isAcceptable ? t : tree);
    }

    public void visit(@Nullable List<? extends T> nodes, P p) {
        if (nodes != null) {
            for (Tree node : nodes) {
                this.visit(node, p);
            }
        }
    }

    public @Nullable T defaultValue(@Nullable Tree tree, P p) {
        return (T)tree;
    }

    @Incubating(since="7.0.0")
    protected final <T2 extends Tree> T2 visitAndCast(T2 t, P p, BiFunction<T2, P, Tree> callSuper) {
        return (T2)callSuper.apply(t, p);
    }

    @Incubating(since="7.0.0")
    protected final <T2 extends T> @Nullable T2 visitAndCast(@Nullable Tree tree, P p) {
        return (T2)this.visit(tree, p);
    }

    public Markers visitMarkers(@Nullable Markers markers, P p) {
        if (markers == null || markers == Markers.EMPTY) {
            return Markers.EMPTY;
        }
        if (markers.getMarkers().isEmpty()) {
            return markers;
        }
        return markers.withMarkers(ListUtils.map(markers.getMarkers(), marker -> this.visitMarker((Marker)marker, p)));
    }

    public <M extends Marker> M visitMarker(Marker marker, P p) {
        return (M)marker;
    }

    public boolean isAdaptableTo(Class<? extends TreeVisitor> adaptTo) {
        if (adaptTo.isAssignableFrom(this.getClass())) {
            return true;
        }
        Class<Tree> mine = this.visitorTreeType(this.getClass());
        Class<Tree> theirs = this.visitorTreeType(adaptTo);
        return mine.isAssignableFrom(theirs);
    }

    protected Class<? extends Tree> visitorTreeType(Class<? extends TreeVisitor> v) {
        for (TypeVariable<Class<? extends TreeVisitor>> tp : v.getTypeParameters()) {
            for (Type bound : tp.getBounds()) {
                if (!(bound instanceof Class) || !Tree.class.isAssignableFrom((Class)bound)) continue;
                return (Class)bound;
            }
        }
        Type sup = v.getGenericSuperclass();
        for (int i = 0; i < 20; ++i) {
            if (sup instanceof ParameterizedType) {
                for (Type bound : ((ParameterizedType)sup).getActualTypeArguments()) {
                    if (!(bound instanceof Class) || !Tree.class.isAssignableFrom((Class)bound)) continue;
                    return (Class)bound;
                }
                sup = ((ParameterizedType)sup).getRawType();
                continue;
            }
            if (!(sup instanceof Class)) continue;
            sup = ((Class)sup).getGenericSuperclass();
        }
        throw new IllegalArgumentException("Expected to find a tree type somewhere in the type parameters of the type hierarchy of visitor " + this.getClass().getName());
    }

    public <R extends Tree, V extends TreeVisitor<R, P>> V adapt(Class<? extends V> adaptTo) {
        if (adaptTo.isAssignableFrom(this.getClass())) {
            return (V)this;
        }
        if (!this.isAdaptableTo(adaptTo)) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be adaptable to " + adaptTo.getName() + ".");
        }
        return (V)((TreeVisitor)TreeVisitorAdapter.adapt(this, adaptTo, new TreeVisitor[0]));
    }

    @Incubating(since="8.0.0")
    public void stopAfterPreVisit() {
        this.getCursor().putMessage(STOP_AFTER_PRE_VISIT, true);
    }
}

