/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.function.Function;
import java.util.function.Predicate;

public class StreamUtils {
    public static <T> Predicate<T> distinctBy(Function<? super T, ?> keyFunc) {
        HashSet seen = new HashSet();
        return t -> {
            Object it = keyFunc.apply(t);
            boolean alreadySeen = seen.contains(it);
            seen.add(it);
            return !alreadySeen;
        };
    }

    public static byte[] readAllBytes(InputStream is) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        try {
            int byteCount;
            while ((byteCount = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, byteCount);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return buffer.toByteArray();
    }
}

