/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.file.Path;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.PathUtils;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.table.SourcesFiles;

public final class FindSourceFiles
extends Recipe {
    private final transient SourcesFiles results = new SourcesFiles(this);
    @Option(displayName="File pattern", description="A glob expression representing a file path to search for (relative to the project root). Blank/null matches all.", required=false, example=".github/workflows/*.yml")
    private final @org.jspecify.annotations.Nullable String filePattern;

    @Override
    public String getDisplayName() {
        return "Find files";
    }

    @Override
    public String getDescription() {
        return "Find files by source path.";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public @org.jspecify.annotations.Nullable Tree visit(@org.jspecify.annotations.Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    SourceFile sourceFile = (SourceFile)tree;
                    Path sourcePath = sourceFile.getSourcePath();
                    if (StringUtils.isBlank(FindSourceFiles.this.filePattern) || PathUtils.matchesGlob(sourcePath, FindSourceFiles.normalize(FindSourceFiles.this.filePattern))) {
                        FindSourceFiles.this.results.insertRow(ctx, new SourcesFiles.Row(sourcePath.toString(), tree.getClass().getSimpleName()));
                        return SearchResult.found(sourceFile);
                    }
                }
                return tree;
            }
        };
    }

    private static String normalize(String filePattern) {
        if (filePattern.startsWith("./") || filePattern.startsWith(".\\")) {
            return filePattern.substring(2);
        }
        if (filePattern.startsWith("/") || filePattern.startsWith("\\")) {
            return filePattern.substring(1);
        }
        return filePattern;
    }

    @Generated
    public FindSourceFiles(@org.jspecify.annotations.Nullable String filePattern) {
        this.filePattern = filePattern;
    }

    @Generated
    public SourcesFiles getResults() {
        return this.results;
    }

    @Generated
    public @org.jspecify.annotations.Nullable String getFilePattern() {
        return this.filePattern;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindSourceFiles(results=" + this.getResults() + ", filePattern=" + this.getFilePattern() + ")";
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindSourceFiles)) {
            return false;
        }
        FindSourceFiles other = (FindSourceFiles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        return !(this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindSourceFiles;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        return result;
    }
}

