/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.transport;

import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import org.openrewrite.shaded.jgit.errors.NotSupportedException;
import org.openrewrite.shaded.jgit.errors.TransportException;
import org.openrewrite.shaded.jgit.internal.JGitText;
import org.openrewrite.shaded.jgit.lib.Repository;
import org.openrewrite.shaded.jgit.transport.BasePackFetchConnection;
import org.openrewrite.shaded.jgit.transport.FetchConnection;
import org.openrewrite.shaded.jgit.transport.InternalFetchConnection;
import org.openrewrite.shaded.jgit.transport.InternalPushConnection;
import org.openrewrite.shaded.jgit.transport.PackTransport;
import org.openrewrite.shaded.jgit.transport.PushConnection;
import org.openrewrite.shaded.jgit.transport.Transport;
import org.openrewrite.shaded.jgit.transport.TransportProtocol;
import org.openrewrite.shaded.jgit.transport.URIish;
import org.openrewrite.shaded.jgit.transport.resolver.ReceivePackFactory;
import org.openrewrite.shaded.jgit.transport.resolver.UploadPackFactory;

public class TestProtocol<C>
extends TransportProtocol {
    private static final String SCHEME = "test";
    private static BasePackFetchConnection.FetchConfig fetchConfig;
    final UploadPackFactory<C> uploadPackFactory;
    final ReceivePackFactory<C> receivePackFactory;
    private final HashMap<URIish, Handle> handles;

    public TestProtocol(UploadPackFactory<C> uploadPackFactory, ReceivePackFactory<C> receivePackFactory) {
        this.uploadPackFactory = uploadPackFactory;
        this.receivePackFactory = receivePackFactory;
        this.handles = new HashMap();
    }

    @Override
    public String getName() {
        return JGitText.get().transportProtoTest;
    }

    @Override
    public Set<String> getSchemes() {
        return Collections.singleton(SCHEME);
    }

    @Override
    public Transport open(URIish uri, Repository local, String remoteName) throws NotSupportedException, TransportException {
        Handle h = this.handles.get(uri);
        if (h == null) {
            throw new NotSupportedException(MessageFormat.format(JGitText.get().URINotSupported, uri));
        }
        return new TransportInternal(local, uri, h);
    }

    @Override
    public Set<TransportProtocol.URIishField> getRequiredFields() {
        return EnumSet.of(TransportProtocol.URIishField.HOST, TransportProtocol.URIishField.PATH);
    }

    @Override
    public Set<TransportProtocol.URIishField> getOptionalFields() {
        return Collections.emptySet();
    }

    static void setFetchConfig(BasePackFetchConnection.FetchConfig c) {
        fetchConfig = c;
    }

    public synchronized URIish register(C req, Repository remote) {
        URIish uri;
        try {
            int n = this.handles.size();
            uri = new URIish("test://test/conn" + n);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        this.handles.put(uri, new Handle(req, remote));
        return uri;
    }

    private class Handle {
        final C req;
        final Repository remote;

        Handle(C req, Repository remote) {
            this.req = req;
            this.remote = remote;
        }
    }

    private class TransportInternal
    extends Transport
    implements PackTransport {
        private final Handle handle;

        TransportInternal(Repository local, URIish uri, Handle handle) {
            super(local, uri);
            this.handle = handle;
        }

        @Override
        public FetchConnection openFetch() throws NotSupportedException, TransportException {
            this.handle.remote.incrementOpen();
            return new InternalFetchConnection<C>(this, TestProtocol.this.uploadPackFactory, this.handle.req, this.handle.remote){

                @Override
                BasePackFetchConnection.FetchConfig getFetchConfig() {
                    return fetchConfig != null ? fetchConfig : super.getFetchConfig();
                }
            };
        }

        @Override
        public PushConnection openPush() throws NotSupportedException, TransportException {
            this.handle.remote.incrementOpen();
            return new InternalPushConnection(this, TestProtocol.this.receivePackFactory, this.handle.req, this.handle.remote);
        }

        @Override
        public void close() {
        }
    }
}

