/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.lib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.openrewrite.shaded.jgit.api.errors.JGitInternalException;
import org.openrewrite.shaded.jgit.internal.JGitText;
import org.openrewrite.shaded.jgit.lib.AnyObjectId;
import org.openrewrite.shaded.jgit.lib.Constants;
import org.openrewrite.shaded.jgit.lib.GpgSignature;
import org.openrewrite.shaded.jgit.lib.ObjectBuilder;
import org.openrewrite.shaded.jgit.lib.ObjectId;
import org.openrewrite.shaded.jgit.lib.PersonIdent;
import org.openrewrite.shaded.jgit.revwalk.RevObject;
import org.openrewrite.shaded.jgit.util.References;

public class TagBuilder
extends ObjectBuilder {
    private static final byte[] hobject = Constants.encodeASCII("object");
    private static final byte[] htype = Constants.encodeASCII("type");
    private static final byte[] htag = Constants.encodeASCII("tag");
    private static final byte[] htagger = Constants.encodeASCII("tagger");
    private ObjectId object;
    private int type = -1;
    private String tag;

    public int getObjectType() {
        return this.type;
    }

    public ObjectId getObjectId() {
        return this.object;
    }

    public void setObjectId(AnyObjectId obj, int objType) {
        this.object = obj.copy();
        this.type = objType;
    }

    public void setObjectId(RevObject obj) {
        this.setObjectId(obj, obj.getType());
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String shortName) {
        this.tag = shortName;
    }

    public PersonIdent getTagger() {
        return this.getAuthor();
    }

    public void setTagger(PersonIdent taggerIdent) {
        this.setAuthor(taggerIdent);
    }

    @Override
    public byte[] build() throws UnsupportedEncodingException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)os, this.getEncoding());){
                GpgSignature signature;
                os.write(hobject);
                os.write(32);
                this.getObjectId().copyTo(os);
                os.write(10);
                os.write(htype);
                os.write(32);
                os.write(Constants.encodeASCII(Constants.typeString(this.getObjectType())));
                os.write(10);
                os.write(htag);
                os.write(32);
                w.write(this.getTag());
                w.flush();
                os.write(10);
                if (this.getTagger() != null) {
                    os.write(htagger);
                    os.write(32);
                    w.write(this.getTagger().toExternalString());
                    w.flush();
                    os.write(10);
                }
                TagBuilder.writeEncoding(this.getEncoding(), os);
                os.write(10);
                String msg = this.getMessage();
                if (msg != null) {
                    w.write(msg);
                    w.flush();
                }
                if ((signature = this.getGpgSignature()) != null) {
                    if (msg != null && !msg.isEmpty() && !msg.endsWith("\n")) {
                        throw new JGitInternalException(JGitText.get().signedTagMessageNoLf);
                    }
                    String externalForm = signature.toExternalString();
                    w.write(externalForm);
                    w.flush();
                    if (!externalForm.endsWith("\n")) {
                        os.write(10);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
        return os.toByteArray();
    }

    @Deprecated
    public byte[] toByteArray() {
        try {
            return this.build();
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public String toString() {
        Charset encoding;
        StringBuilder r = new StringBuilder();
        r.append("Tag");
        r.append("={\n");
        r.append("object ");
        r.append(this.object != null ? this.object.name() : "NOT_SET");
        r.append("\n");
        r.append("type ");
        r.append(this.object != null ? Constants.typeString(this.type) : "NOT_SET");
        r.append("\n");
        r.append("tag ");
        r.append(this.tag != null ? this.tag : "NOT_SET");
        r.append("\n");
        if (this.getTagger() != null) {
            r.append("tagger ");
            r.append(this.getTagger());
            r.append("\n");
        }
        if (!References.isSameObject(encoding = this.getEncoding(), StandardCharsets.UTF_8)) {
            r.append("encoding ");
            r.append(encoding.name());
            r.append("\n");
        }
        r.append("\n");
        r.append(this.getMessage() != null ? this.getMessage() : "");
        GpgSignature signature = this.getGpgSignature();
        r.append(signature != null ? signature.toExternalString() : "");
        r.append("}");
        return r.toString();
    }
}

