/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.internal.storage.pack;

import org.openrewrite.shaded.jgit.internal.storage.pack.DeltaIndex;

class DeltaIndexScanner {
    final int[] table;
    final long[] entries;
    final int[] next;
    final int tableMask;
    private int entryCnt;

    DeltaIndexScanner(byte[] raw, int len) {
        len -= len % 16;
        int worstCaseBlockCnt = len / 16;
        if (worstCaseBlockCnt < 1) {
            this.table = new int[0];
            this.tableMask = 0;
            this.entries = new long[0];
            this.next = new int[0];
        } else {
            this.table = new int[DeltaIndexScanner.tableSize(worstCaseBlockCnt)];
            this.tableMask = this.table.length - 1;
            this.entries = new long[1 + worstCaseBlockCnt];
            this.next = new int[this.entries.length];
            this.scan(raw, len);
        }
    }

    private void scan(byte[] raw, int end) {
        int lastHash = 0;
        int ptr = end - 16;
        do {
            int key;
            int tIdx;
            int head;
            if ((head = this.table[tIdx = (key = DeltaIndex.hashBlock(raw, ptr)) & this.tableMask]) != 0 && lastHash == key) {
                this.entries[head] = (long)key << 32 | (long)ptr;
            } else {
                int eIdx = ++this.entryCnt;
                this.entries[eIdx] = (long)key << 32 | (long)ptr;
                this.next[eIdx] = head;
                this.table[tIdx] = eIdx;
            }
            lastHash = key;
        } while ((ptr -= 16) >= 0);
    }

    private static int tableSize(int worstCaseBlockCnt) {
        int shift = 32 - Integer.numberOfLeadingZeros(worstCaseBlockCnt);
        int sz = 1 << shift - 1;
        if (sz < worstCaseBlockCnt) {
            sz <<= 1;
        }
        return sz;
    }
}

