/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.Resource;
import io.github.classgraph.ResourceList;
import io.github.classgraph.ScanResult;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.table.ClasspathReport;

public class ListRuntimeClasspath
extends ScanningRecipe<Void> {
    transient ClasspathReport report = new ClasspathReport(this);

    @Override
    public String getDisplayName() {
        return "List runtime classpath";
    }

    @Override
    public String getDescription() {
        return "A diagnostic utility which emits the runtime classpath to a data table.";
    }

    @Override
    public Void getInitialValue(ExecutionContext ctx) {
        return null;
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getScanner(Void acc) {
        return TreeVisitor.noop();
    }

    @Override
    public Collection<? extends SourceFile> generate(Void acc, ExecutionContext ctx) {
        try (ScanResult result = new ClassGraph().scan();){
            ResourceList resources = result.getResourcesWithExtension(".jar");
            Map<String, List<Resource>> classpathEntriesWithJarResources = resources.stream().collect(Collectors.groupingBy(it -> it.getClasspathElementURI().toString()));
            for (URI classPathUri : result.getClasspathURIs()) {
                List<Resource> jarResources = classpathEntriesWithJarResources.get(classPathUri.toString());
                if (jarResources == null || jarResources.isEmpty()) {
                    this.report.insertRow(ctx, new ClasspathReport.Row(classPathUri.toString(), ""));
                    continue;
                }
                for (Resource r : jarResources) {
                    this.report.insertRow(ctx, new ClasspathReport.Row(classPathUri.toString(), r.getPath()));
                }
            }
        }
        return Collections.emptyList();
    }
}

