/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.treewalk;

import java.io.IOException;
import org.openrewrite.shaded.jgit.errors.CorruptObjectException;
import org.openrewrite.shaded.jgit.errors.IncorrectObjectTypeException;
import org.openrewrite.shaded.jgit.lib.ObjectId;
import org.openrewrite.shaded.jgit.lib.ObjectReader;
import org.openrewrite.shaded.jgit.treewalk.AbstractTreeIterator;

public class EmptyTreeIterator
extends AbstractTreeIterator {
    public EmptyTreeIterator() {
    }

    EmptyTreeIterator(AbstractTreeIterator p) {
        super(p);
        this.pathLen = this.pathOffset;
    }

    public EmptyTreeIterator(AbstractTreeIterator p, byte[] childPath, int childPathOffset) {
        super(p, childPath, childPathOffset);
        this.pathLen = childPathOffset - 1;
    }

    @Override
    public AbstractTreeIterator createSubtreeIterator(ObjectReader reader) throws IncorrectObjectTypeException, IOException {
        return new EmptyTreeIterator(this);
    }

    @Override
    public boolean hasId() {
        return false;
    }

    @Override
    public ObjectId getEntryObjectId() {
        return ObjectId.zeroId();
    }

    @Override
    public byte[] idBuffer() {
        return zeroid;
    }

    @Override
    public int idOffset() {
        return 0;
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean first() {
        return true;
    }

    @Override
    public boolean eof() {
        return true;
    }

    @Override
    public void next(int delta) throws CorruptObjectException {
    }

    @Override
    public void back(int delta) throws CorruptObjectException {
    }

    @Override
    public void stopWalk() {
        if (this.parent != null) {
            this.parent.stopWalk();
        }
    }

    @Override
    protected boolean needsStopWalk() {
        return this.parent != null && this.parent.needsStopWalk();
    }
}

