/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.transport;

import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.openrewrite.shaded.jgit.internal.JGitText;
import org.openrewrite.shaded.jgit.util.Hex;
import org.openrewrite.shaded.jgit.util.HttpSupport;

public final class AwsRequestSignerV4 {
    private static final String ALGORITHM = "HMAC-SHA256";
    private static final String MAC_ALGORITHM = "HmacSHA256";
    private static final String SCHEME = "AWS4";
    private static final String TERMINATOR = "aws4_request";
    private static final String EMPTY_BODY_SHA256 = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
    private static final DateTimeFormatter AMZ_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'");
    private static final DateTimeFormatter SCOPE_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd");

    private AwsRequestSignerV4() {
    }

    public static void sign(HttpURLConnection httpURLConnection, Map<String, String> queryParameters, long contentLength, String bodyHash, String serviceName, String regionName, String awsAccessKey, char[] awsSecretKey) {
        HashMap<String, String> headers = new HashMap<String, String>();
        httpURLConnection.getRequestProperties().forEach((headerName, headerValues) -> {
            String string = headers.put((String)headerName, String.join((CharSequence)",", headerValues));
        });
        if (contentLength > 0L) {
            headers.put("Content-Length", String.valueOf(contentLength));
        } else {
            bodyHash = EMPTY_BODY_SHA256;
        }
        headers.put("x-amz-content-sha256", bodyHash);
        OffsetDateTime now = Instant.now().atOffset(ZoneOffset.UTC);
        String amzDate = now.format(AMZ_DATE_FORMAT);
        headers.put("x-amz-date", amzDate);
        URL endpointUrl = httpURLConnection.getURL();
        int port = endpointUrl.getPort();
        String hostHeader = port > -1 ? endpointUrl.getHost().concat(":" + port) : endpointUrl.getHost();
        headers.put("Host", hostHeader);
        String canonicalizedHeaderNames = AwsRequestSignerV4.getCanonicalizeHeaderNames(headers);
        String canonicalizedHeaders = AwsRequestSignerV4.getCanonicalizedHeaderString(headers);
        String canonicalizedQueryParameters = AwsRequestSignerV4.getCanonicalizedQueryString(queryParameters);
        String httpMethod = httpURLConnection.getRequestMethod();
        String canonicalRequest = String.valueOf(httpMethod) + '\n' + AwsRequestSignerV4.getCanonicalizedResourcePath(endpointUrl) + '\n' + canonicalizedQueryParameters + '\n' + canonicalizedHeaders + '\n' + canonicalizedHeaderNames + '\n' + bodyHash;
        String scopeDate = now.format(SCOPE_DATE_FORMAT);
        String scope = String.valueOf(scopeDate) + '/' + regionName + '/' + serviceName + '/' + TERMINATOR;
        String stringToSign = "AWS4-HMAC-SHA256\n" + amzDate + '\n' + scope + '\n' + Hex.toHexString(AwsRequestSignerV4.hash(canonicalRequest.getBytes(StandardCharsets.UTF_8)));
        byte[] secretKey = (SCHEME + new String(awsSecretKey)).getBytes();
        byte[] dateKey = AwsRequestSignerV4.signStringWithKey(scopeDate, secretKey);
        byte[] regionKey = AwsRequestSignerV4.signStringWithKey(regionName, dateKey);
        byte[] serviceKey = AwsRequestSignerV4.signStringWithKey(serviceName, regionKey);
        byte[] signingKey = AwsRequestSignerV4.signStringWithKey(TERMINATOR, serviceKey);
        byte[] signature = AwsRequestSignerV4.signStringWithKey(stringToSign, signingKey);
        String credentialsAuthorizationHeader = "Credential=" + awsAccessKey + '/' + scope;
        String signedHeadersAuthorizationHeader = "SignedHeaders=" + canonicalizedHeaderNames;
        String signatureAuthorizationHeader = "Signature=" + Hex.toHexString(signature);
        String authorizationHeader = "AWS4-HMAC-SHA256 " + credentialsAuthorizationHeader + ", " + signedHeadersAuthorizationHeader + ", " + signatureAuthorizationHeader;
        headers.forEach(httpURLConnection::setRequestProperty);
        httpURLConnection.setRequestProperty("Authorization", authorizationHeader);
    }

    public static String calculateBodyHash(byte[] data) {
        return data == null || data.length < 1 ? EMPTY_BODY_SHA256 : Hex.toHexString(AwsRequestSignerV4.hash(data));
    }

    private static String getCanonicalizeHeaderNames(Map<String, String> headers) {
        return headers.keySet().stream().map(String::toLowerCase).sorted().collect(Collectors.joining(";"));
    }

    private static String getCanonicalizedHeaderString(Map<String, String> headers) {
        if (headers == null || headers.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        headers.keySet().stream().sorted(String.CASE_INSENSITIVE_ORDER).forEach(key -> {
            String header = key.toLowerCase().replaceAll("\\s+", " ");
            String value = ((String)headers.get(key)).replaceAll("\\s+", " ");
            sb.append(header).append(':').append(value).append('\n');
        });
        return sb.toString();
    }

    private static String getCanonicalizedResourcePath(URL url) {
        if (url == null) {
            return "/";
        }
        String path = url.getPath();
        if (path == null || path.isEmpty()) {
            return "/";
        }
        String encodedPath = HttpSupport.urlEncode(path, true);
        if (encodedPath.startsWith("/")) {
            return encodedPath;
        }
        return "/".concat(encodedPath);
    }

    public static String getCanonicalizedQueryString(Map<String, String> queryParameters) {
        if (queryParameters == null || queryParameters.isEmpty()) {
            return "";
        }
        return queryParameters.keySet().stream().sorted().map(key -> String.valueOf(HttpSupport.urlEncode(key, false)) + '=' + HttpSupport.urlEncode((String)queryParameters.get(key), false)).collect(Collectors.joining("&"));
    }

    public static byte[] hash(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(data);
            return md.digest();
        }
        catch (Exception e) {
            throw new RuntimeException(JGitText.get().couldNotHashByteArrayWithSha256, e);
        }
    }

    private static byte[] signStringWithKey(String stringToSign, byte[] key) {
        try {
            byte[] data = stringToSign.getBytes(StandardCharsets.UTF_8);
            Mac mac = Mac.getInstance(MAC_ALGORITHM);
            mac.init(new SecretKeySpec(key, MAC_ALGORITHM));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException(JGitText.get().couldNotSignStringWithKey, e);
        }
    }
}

