/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.revwalk.filter;

import org.openrewrite.shaded.jgit.internal.JGitText;
import org.openrewrite.shaded.jgit.revwalk.RevCommit;
import org.openrewrite.shaded.jgit.revwalk.filter.PatternMatchRevFilter;
import org.openrewrite.shaded.jgit.revwalk.filter.RevFilter;
import org.openrewrite.shaded.jgit.revwalk.filter.SubStringRevFilter;
import org.openrewrite.shaded.jgit.util.RawCharSequence;
import org.openrewrite.shaded.jgit.util.RawParseUtils;

public class CommitterRevFilter {
    public static RevFilter create(String pattern) {
        if (pattern.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().cannotMatchOnEmptyString);
        }
        if (SubStringRevFilter.safe(pattern)) {
            return new SubStringSearch(pattern);
        }
        return new PatternSearch(pattern);
    }

    private CommitterRevFilter() {
    }

    static RawCharSequence textFor(RevCommit cmit) {
        byte[] raw = cmit.getRawBuffer();
        int b = RawParseUtils.committer(raw, 0);
        if (b < 0) {
            return RawCharSequence.EMPTY;
        }
        int e = RawParseUtils.nextLF(raw, b, '>');
        return new RawCharSequence(raw, b, e);
    }

    private static class PatternSearch
    extends PatternMatchRevFilter {
        PatternSearch(String patternText) {
            super(patternText, true, true, 2);
        }

        @Override
        protected CharSequence text(RevCommit cmit) {
            return CommitterRevFilter.textFor(cmit);
        }

        @Override
        public RevFilter clone() {
            return new PatternSearch(this.pattern());
        }
    }

    private static class SubStringSearch
    extends SubStringRevFilter {
        SubStringSearch(String patternText) {
            super(patternText);
        }

        @Override
        protected RawCharSequence text(RevCommit cmit) {
            return CommitterRevFilter.textFor(cmit);
        }
    }
}

