/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.openrewrite.DelegatingExecutionContext;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.lang.Nullable;

public class WorkingDirectoryExecutionContextView
extends DelegatingExecutionContext
implements AutoCloseable {
    @Nullable
    private final Path existing;

    private WorkingDirectoryExecutionContextView(ExecutionContext delegate, @Nullable Path existing) {
        super(delegate);
        this.existing = existing;
        try {
            if (existing != null) {
                if (!Files.isDirectory(existing, new LinkOption[0])) {
                    Files.createDirectories(existing, new FileAttribute[0]);
                }
                this.putMessage("org.openrewrite.workingDirectory", existing);
            } else {
                this.putMessage("org.openrewrite.workingDirectory", Files.createTempDirectory("recipe-wd", new FileAttribute[0]));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static WorkingDirectoryExecutionContextView createNew(ExecutionContext ctx) {
        if (ctx instanceof WorkingDirectoryExecutionContextView) {
            return (WorkingDirectoryExecutionContextView)ctx;
        }
        return new WorkingDirectoryExecutionContextView(ctx, null);
    }

    public static WorkingDirectoryExecutionContextView useProvided(ExecutionContext ctx, Path existing) {
        if (ctx instanceof WorkingDirectoryExecutionContextView) {
            return (WorkingDirectoryExecutionContextView)ctx;
        }
        return new WorkingDirectoryExecutionContextView(ctx, existing);
    }

    public static Path getWorkingDirectory(ExecutionContext ctx) {
        return Optional.ofNullable((Path)ctx.getMessage("org.openrewrite.workingDirectory")).orElseThrow(() -> new IllegalStateException("Working directory not set"));
    }

    @Override
    public void close() {
        if (this.existing == null) {
            this.delete(Objects.requireNonNull((Path)this.getMessage("org.openrewrite.workingDirectory")));
        }
    }

    private void delete(Path path) {
        try {
            if (Files.isDirectory(path, new LinkOption[0])) {
                try (Stream<Path> files = Files.list(path);){
                    files.forEach(this::delete);
                }
            }
            Files.delete(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

