/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.util.Optional;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.SearchResult;

public final class IsInRepository
extends Recipe {
    @Option(displayName="Allowed repositories", description="The names of the repositories that are allowed to be searched. Determines repository name according to git metadata recorded in the `GitProvenance` marker.", example="rewrite")
    private final Set<String> allowedRepositories;

    @Override
    public String getDisplayName() {
        return "Is in repository";
    }

    @Override
    public String getDescription() {
        return "A search recipe which marks files that are in a repository with one of the supplied names. Intended for use as a precondition for other recipes being run over many different repositories.";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext executionContext) {
                if (tree == null) {
                    return null;
                }
                Optional<GitProvenance> maybeGp = tree.getMarkers().findFirst(GitProvenance.class);
                if (maybeGp.isPresent()) {
                    GitProvenance gp = maybeGp.get();
                    if (IsInRepository.this.allowedRepositories.contains(gp.getRepositoryName())) {
                        return SearchResult.found(tree);
                    }
                }
                return tree;
            }
        };
    }

    public IsInRepository(Set<String> allowedRepositories) {
        this.allowedRepositories = allowedRepositories;
    }

    public Set<String> getAllowedRepositories() {
        return this.allowedRepositories;
    }

    @NonNull
    public String toString() {
        return "IsInRepository(allowedRepositories=" + this.getAllowedRepositories() + ")";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IsInRepository)) {
            return false;
        }
        IsInRepository other = (IsInRepository)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Set<String> this$allowedRepositories = this.getAllowedRepositories();
        Set<String> other$allowedRepositories = other.getAllowedRepositories();
        return !(this$allowedRepositories == null ? other$allowedRepositories != null : !((Object)this$allowedRepositories).equals(other$allowedRepositories));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof IsInRepository;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Set<String> $allowedRepositories = this.getAllowedRepositories();
        result = result * 59 + ($allowedRepositories == null ? 43 : ((Object)$allowedRepositories).hashCode());
        return result;
    }
}

