/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import io.quarkus.gizmo.ClassOutput;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;

public class TreeVisitorAdapterClassLoader
extends ClassLoader
implements ClassOutput {
    private final Map<String, Class<?>> adaptedClasses = new HashMap();

    public TreeVisitorAdapterClassLoader(ClassLoader parent) {
        super(parent);
    }

    public boolean hasClass(String name) {
        return this.adaptedClasses.containsKey(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> ex = this.findLoadedClass(name);
        if (ex != null) {
            return ex;
        }
        if (this.adaptedClasses.containsKey(name)) {
            return this.findClass(name);
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.adaptedClasses.get(name);
        if (clazz == null) {
            throw new ClassNotFoundException();
        }
        return clazz;
    }

    public void write(String name, byte[] data) {
        if (System.getProperty("org.openrewrite.adapt.dumpClass") != null) {
            try {
                File dir = new File("target/test-classes/", name.substring(0, name.lastIndexOf("/")));
                dir.mkdirs();
                File output = new File("target/test-classes/", name + ".class");
                Files.write(output.toPath(), data, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot dump the class: " + name, e);
            }
        }
        String normalizedName = name.replace('/', '.');
        this.adaptedClasses.put(normalizedName, this.defineClass(normalizedName, data, 0, data.length));
    }

    public Writer getSourceWriter(String className) {
        return new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        };
    }
}

