/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.config.ColumnDescriptor;
import org.openrewrite.config.DataTableDescriptor;
import org.openrewrite.config.RecipeIntrospectionException;
import org.openrewrite.internal.ReflectionUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class RecipeIntrospectionUtils {
    public static TreeVisitor<?, ExecutionContext> recipeVisitor(Recipe recipe) {
        try {
            Method getVisitor = ReflectionUtils.findMethod(recipe.getClass(), "getVisitor", new Class[0]);
            if (getVisitor == null) {
                throw new RecipeIntrospectionException("Recipe " + recipe.getName() + " does not implement getVisitor()");
            }
            getVisitor.setAccessible(true);
            return (TreeVisitor)getVisitor.invoke((Object)recipe, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException t) {
            throw new RecipeIntrospectionException("Unable to invoke getVisitor() on " + recipe.getClass().getName(), t);
        }
    }

    public static List<SourceFile> recipeVisit(Recipe recipe, List<SourceFile> before, ExecutionContext ctx) {
        try {
            Method visit = ReflectionUtils.findMethod(recipe.getClass(), "visit", List.class, ExecutionContext.class);
            if (visit == null) {
                throw new RecipeIntrospectionException("Recipe " + recipe.getClass().getName() + " does not implement visit(List<SourceFile>, ExecutionContext)");
            }
            visit.setAccessible(true);
            return (List)visit.invoke((Object)recipe, before, ctx);
        }
        catch (IllegalAccessException | InvocationTargetException t) {
            throw new RecipeIntrospectionException("Unable to invoke visit(List<SourceFile>, ExecutionContext) on " + recipe.getClass().getName(), t);
        }
    }

    public static DataTableDescriptor dataTableDescriptorFromDataTable(DataTable<?> dataTable) {
        return new DataTableDescriptor(dataTable.getName(), dataTable.getDisplayName(), dataTable.getDescription(), RecipeIntrospectionUtils.getColumnDescriptors(dataTable));
    }

    public static Constructor<?> getPrimaryConstructor(Class<?> recipeClass) {
        Constructor<?>[] constructors = recipeClass.getConstructors();
        if (constructors.length == 0) {
            throw new RecipeIntrospectionException("Unable to locate primary constructor for Recipe " + recipeClass);
        }
        if (recipeClass.getConstructors().length == 1) {
            return recipeClass.getConstructors()[0];
        }
        for (Constructor<?> constructor : constructors) {
            for (Annotation annotation : constructor.getAnnotations()) {
                if (!"com.fasterxml.jackson.annotation.JsonCreator".equals(annotation.annotationType().getName())) continue;
                return constructor;
            }
        }
        throw new RecipeIntrospectionException("Unable to locate primary constructor for Recipe " + recipeClass);
    }

    @Nullable
    public static Constructor<?> getZeroArgsConstructor(Class<?> recipeClass) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = recipeClass.getConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            return constructor;
        }
        return null;
    }

    public static Recipe constructRecipe(Class<?> recipeClass) {
        return (Recipe)RecipeIntrospectionUtils.construct(recipeClass);
    }

    private static <V> V construct(Class<?> clazz) {
        Constructor<?> primaryConstructor = RecipeIntrospectionUtils.getZeroArgsConstructor(clazz);
        if (primaryConstructor == null) {
            primaryConstructor = RecipeIntrospectionUtils.getPrimaryConstructor(clazz);
        }
        Object[] constructorArgs = new Object[primaryConstructor.getParameterCount()];
        for (int i = 0; i < primaryConstructor.getParameters().length; ++i) {
            Parameter param = primaryConstructor.getParameters()[i];
            if (param.getType().isPrimitive()) {
                constructorArgs[i] = RecipeIntrospectionUtils.getPrimitiveDefault(param.getType());
                continue;
            }
            if (param.getType().equals(String.class)) {
                constructorArgs[i] = "";
                continue;
            }
            if (Enum.class.isAssignableFrom(param.getType())) {
                try {
                    Object[] values = (Object[])param.getType().getMethod("values", new Class[0]).invoke(null, new Object[0]);
                    constructorArgs[i] = values[0];
                    continue;
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            constructorArgs[i] = List.class.isAssignableFrom(param.getType()) ? Collections.emptyList() : null;
        }
        primaryConstructor.setAccessible(true);
        try {
            return (V)primaryConstructor.newInstance(constructorArgs);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw RecipeIntrospectionUtils.getRecipeIntrospectionException(clazz, e);
        }
    }

    @NonNull
    private static RecipeIntrospectionException getRecipeIntrospectionException(Class<?> recipeClass, ReflectiveOperationException e) {
        return new RecipeIntrospectionException("Unable to call primary constructor for Recipe " + recipeClass, e);
    }

    private static List<ColumnDescriptor> getColumnDescriptors(DataTable<?> dataTable) {
        ArrayList<ColumnDescriptor> columns = new ArrayList<ColumnDescriptor>();
        for (Field field : dataTable.getType().getDeclaredFields()) {
            field.setAccessible(true);
            Column column = field.getAnnotation(Column.class);
            if (column == null) continue;
            columns.add(new ColumnDescriptor(field.getName(), field.getType().getSimpleName(), column.displayName(), column.description()));
        }
        return columns;
    }

    private static Object getPrimitiveDefault(Class<?> t) {
        if (t.equals(Byte.TYPE)) {
            return (byte)0;
        }
        if (t.equals(Short.TYPE)) {
            return (short)0;
        }
        if (t.equals(Integer.TYPE)) {
            return 0;
        }
        if (t.equals(Long.TYPE)) {
            return 0L;
        }
        if (t.equals(Float.TYPE)) {
            return Float.valueOf(0.0f);
        }
        if (t.equals(Double.TYPE)) {
            return 0.0;
        }
        if (t.equals(Character.TYPE)) {
            return Character.valueOf('\u0000');
        }
        if (t.equals(Boolean.TYPE)) {
            return false;
        }
        throw new RecipeIntrospectionException(t.getCanonicalName() + " is not a supported primitive type");
    }
}

