/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.StringJoiner;
import org.openrewrite.internal.RecipeRunException;

public class ExceptionUtils {
    public static String sanitizeStackTrace(Throwable t, Class<?> until) {
        StringJoiner sanitized = new StringJoiner("\n");
        Throwable cause = t instanceof RecipeRunException ? t.getCause() : t;
        sanitized.add(cause.getClass().getName() + ": " + cause.getLocalizedMessage());
        int i = 0;
        for (StackTraceElement stackTraceElement : cause.getStackTrace()) {
            if (stackTraceElement.getClassName().equals(until.getName())) break;
            if (i++ >= 8) {
                sanitized.add("  ...");
                break;
            }
            sanitized.add("  " + stackTraceElement);
        }
        return sanitized.toString();
    }

    public static boolean containsCircularReferences(Throwable exception) {
        Set causes = Collections.newSetFromMap(new IdentityHashMap());
        causes.add(exception);
        boolean containsACircularReference = false;
        while (exception != null && exception.getCause() != null) {
            Throwable exceptionToFind = exception.getCause();
            if (exceptionToFind != null) {
                if (!causes.add(exceptionToFind)) {
                    containsACircularReference = true;
                    break;
                }
                exception = exceptionToFind;
                continue;
            }
            exception = null;
        }
        return containsACircularReference;
    }
}

