/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.GitProvenance;

@JsonIgnoreType
public class DistinctGitProvenance
extends DataTable<Row> {
    public DistinctGitProvenance(Recipe recipe) {
        super(recipe, "Distinct Git Provenance", "List out the contents of each unique `GitProvenance` marker in the set of source files. When everything is working correctly, exactly one such marker should be printed as all source files are expected to come from the same repository / branch / commit hash.");
    }

    public static final class Row {
        @Column(displayName="Origin", description="The URL of the git remote.")
        private final String origin;
        @Column(displayName="Branch", description="The branch that was checked out at the time the source file was parsed.")
        private final String branch;
        @Column(displayName="Changeset", description="The commit hash of the changeset that was checked out.")
        private final String changeset;
        @Column(displayName="AutoCRLF", description="The value of the `core.autocrlf` git config setting.")
        private final GitProvenance.AutoCRLF autoCRLF;
        @Column(displayName="EOL", description="The value of the `core.eol` git config setting.")
        private final GitProvenance.EOL eol;

        public Row(String origin, String branch, String changeset, GitProvenance.AutoCRLF autoCRLF, GitProvenance.EOL eol) {
            this.origin = origin;
            this.branch = branch;
            this.changeset = changeset;
            this.autoCRLF = autoCRLF;
            this.eol = eol;
        }

        public String getOrigin() {
            return this.origin;
        }

        public String getBranch() {
            return this.branch;
        }

        public String getChangeset() {
            return this.changeset;
        }

        public GitProvenance.AutoCRLF getAutoCRLF() {
            return this.autoCRLF;
        }

        public GitProvenance.EOL getEol() {
            return this.eol;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$origin = this.getOrigin();
            String other$origin = other.getOrigin();
            if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
                return false;
            }
            String this$branch = this.getBranch();
            String other$branch = other.getBranch();
            if (this$branch == null ? other$branch != null : !this$branch.equals(other$branch)) {
                return false;
            }
            String this$changeset = this.getChangeset();
            String other$changeset = other.getChangeset();
            if (this$changeset == null ? other$changeset != null : !this$changeset.equals(other$changeset)) {
                return false;
            }
            GitProvenance.AutoCRLF this$autoCRLF = this.getAutoCRLF();
            GitProvenance.AutoCRLF other$autoCRLF = other.getAutoCRLF();
            if (this$autoCRLF == null ? other$autoCRLF != null : !((Object)((Object)this$autoCRLF)).equals((Object)other$autoCRLF)) {
                return false;
            }
            GitProvenance.EOL this$eol = this.getEol();
            GitProvenance.EOL other$eol = other.getEol();
            return !(this$eol == null ? other$eol != null : !((Object)((Object)this$eol)).equals((Object)other$eol));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $origin = this.getOrigin();
            result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
            String $branch = this.getBranch();
            result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
            String $changeset = this.getChangeset();
            result = result * 59 + ($changeset == null ? 43 : $changeset.hashCode());
            GitProvenance.AutoCRLF $autoCRLF = this.getAutoCRLF();
            result = result * 59 + ($autoCRLF == null ? 43 : ((Object)((Object)$autoCRLF)).hashCode());
            GitProvenance.EOL $eol = this.getEol();
            result = result * 59 + ($eol == null ? 43 : ((Object)((Object)$eol)).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "DistinctGitProvenance.Row(origin=" + this.getOrigin() + ", branch=" + this.getBranch() + ", changeset=" + this.getChangeset() + ", autoCRLF=" + (Object)((Object)this.getAutoCRLF()) + ", eol=" + (Object)((Object)this.getEol()) + ")";
        }
    }
}

