/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.diff;

import java.text.MessageFormat;
import org.openrewrite.shaded.jgit.internal.JGitText;
import org.openrewrite.shaded.jgit.lib.Config;
import org.openrewrite.shaded.jgit.util.StringUtils;

public class DiffConfig {
    public static final Config.SectionParser<DiffConfig> KEY = DiffConfig::new;
    private final boolean noPrefix;
    private final RenameDetectionType renameDetectionType;
    private final int renameLimit;

    private DiffConfig(Config rc) {
        this.noPrefix = rc.getBoolean("diff", "noprefix", false);
        this.renameDetectionType = DiffConfig.parseRenameDetectionType(rc.getString("diff", null, "renames"));
        this.renameLimit = rc.getInt("diff", "renamelimit", 400);
    }

    public boolean isNoPrefix() {
        return this.noPrefix;
    }

    public boolean isRenameDetectionEnabled() {
        return this.renameDetectionType != RenameDetectionType.FALSE;
    }

    public RenameDetectionType getRenameDetectionType() {
        return this.renameDetectionType;
    }

    public int getRenameLimit() {
        return this.renameLimit;
    }

    private static RenameDetectionType parseRenameDetectionType(String renameString) {
        if (renameString == null) {
            return RenameDetectionType.FALSE;
        }
        if (StringUtils.equalsIgnoreCase("copy", renameString) || StringUtils.equalsIgnoreCase("copies", renameString)) {
            return RenameDetectionType.COPY;
        }
        Boolean renameBoolean = StringUtils.toBooleanOrNull(renameString);
        if (renameBoolean == null) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().enumValueNotSupported2, "diff", "renames", renameString));
        }
        if (renameBoolean.booleanValue()) {
            return RenameDetectionType.TRUE;
        }
        return RenameDetectionType.FALSE;
    }

    public static enum RenameDetectionType {
        FALSE,
        TRUE,
        COPY;

    }
}

