/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jcl.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.openrewrite.internal.lang.Nullable;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public class Space {
    public static final Space EMPTY = new Space("", false);
    @Nullable
    private final String whitespace;
    @Nullable
    private final Boolean isContinued;
    private static final Map<String, Space> flyweights = Collections.synchronizedMap(new WeakHashMap());
    private static final String[] spaces = new String[]{"\u00b7\u2081", "\u00b7\u2082", "\u00b7\u2083", "\u00b7\u2084", "\u00b7\u2085", "\u00b7\u2086", "\u00b7\u2087", "\u00b7\u2088", "\u00b7\u2089", "\u00b7\u208a"};
    private static final String[] tabs = new String[]{"-\u2081", "-\u2082", "-\u2083", "-\u2084", "-\u2085", "-\u2086", "-\u2087", "-\u2088", "-\u2089", "-\u208a"};

    private Space(@Nullable String whitespace, @Nullable Boolean isContinued) {
        this.whitespace = whitespace == null || whitespace.isEmpty() ? null : whitespace;
        this.isContinued = isContinued;
    }

    @JsonCreator
    public static Space build(@Nullable String whitespace, @Nullable Boolean isContinued) {
        if (!Boolean.TRUE.equals(isContinued) && (whitespace == null || whitespace.isEmpty())) {
            return EMPTY;
        }
        if (whitespace == null || whitespace.length() <= 100) {
            String key = (whitespace == null ? "" : whitespace) + (isContinued != null && isContinued != false);
            return flyweights.computeIfAbsent(key, k -> new Space(whitespace, isContinued));
        }
        return new Space(whitespace, isContinued);
    }

    public String getIndent() {
        return this.getWhitespaceIndent(this.whitespace);
    }

    private String getWhitespaceIndent(@Nullable String whitespace) {
        if (whitespace == null) {
            return "";
        }
        int lastNewline = whitespace.lastIndexOf(10);
        if (lastNewline >= 0) {
            return whitespace.substring(lastNewline + 1);
        }
        if (lastNewline == whitespace.length() - 1) {
            return "";
        }
        return whitespace;
    }

    public String getWhitespace() {
        return this.whitespace == null ? "" : this.whitespace;
    }

    public Space withWhitespace(String whitespace) {
        if (whitespace.isEmpty()) {
            return EMPTY;
        }
        if (this.whitespace == null || whitespace.equals(this.whitespace)) {
            return this;
        }
        return Space.build(whitespace, this.isContinued);
    }

    public Boolean isContinued() {
        return this.isContinued != null && this.isContinued != false;
    }

    public Space withContinued(boolean continued) {
        if (this.isContinued == null || continued == this.isContinued) {
            return this;
        }
        return Space.build(this.whitespace, continued);
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public String toString() {
        StringBuilder printedWs = new StringBuilder();
        int lastNewline = 0;
        if (this.whitespace != null) {
            char[] charArray = this.whitespace.toCharArray();
            for (int i = 0; i < charArray.length; ++i) {
                char c = charArray[i];
                if (c == '\n') {
                    printedWs.append("\\n");
                    lastNewline = i + 1;
                    continue;
                }
                if (c == '\r') {
                    printedWs.append("\\r");
                    lastNewline = i + 1;
                    continue;
                }
                if (c == ' ') {
                    printedWs.append(spaces[(i - lastNewline) % 10]);
                    continue;
                }
                if (c != '\t') continue;
                printedWs.append(tabs[(i - lastNewline) % 10]);
            }
        }
        return "Space(whitespace='" + printedWs + "')";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Space)) {
            return false;
        }
        Space other = (Space)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isContinued = this.isContinued;
        Boolean other$isContinued = other.isContinued;
        if (this$isContinued == null ? other$isContinued != null : !((Object)this$isContinued).equals(other$isContinued)) {
            return false;
        }
        String this$whitespace = this.getWhitespace();
        String other$whitespace = other.getWhitespace();
        return !(this$whitespace == null ? other$whitespace != null : !this$whitespace.equals(other$whitespace));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Space;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isContinued = this.isContinued;
        result = result * 59 + ($isContinued == null ? 43 : ((Object)$isContinued).hashCode());
        String $whitespace = this.getWhitespace();
        result = result * 59 + ($whitespace == null ? 43 : $whitespace.hashCode());
        return result;
    }

    public static enum Location {
        TODO,
        ASSIGNMENT,
        ASSIGNMENT_PREFIX,
        COMPILATION_UNIT_PREFIX,
        COMPILATION_UNIT_EOF,
        DATA_DEFINITION_STATEMENT_PREFIX,
        EXEC_STATEMENT_PREFIX,
        IDENTIFIER_PREFIX,
        JCL_STATEMENT_PREFIX,
        JOB_STATEMENT_PREFIX,
        JCL_NAME_PREFIX,
        LITERAL_PREFIX,
        OUTPUT_STATEMENT_PREFIX,
        PARAMETERS,
        PARENTHESES,
        PARENTHESES_PREFIX,
        PEND_PREFIX,
        PROC_STATEMENT_PREFIX,
        SET_STATEMENT_PREFIX,
        XMIT_STATEMENT_PREFIX,
        UNSUPPORTED_PREFIX;

    }
}

