/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jcl.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.jcl.tree.Jcl;
import org.openrewrite.jcl.tree.Space;
import org.openrewrite.marker.Markers;

public class JclRightPadded<T> {
    private final T element;
    private final Space after;
    private final Markers markers;

    public JclRightPadded<T> map(UnaryOperator<T> map) {
        return this.withElement(map.apply(this.element));
    }

    public static <T> List<T> getElements(List<JclRightPadded<T>> ls) {
        ArrayList<T> list = new ArrayList<T>();
        for (JclRightPadded<T> l : ls) {
            T elem = l.getElement();
            list.add(elem);
        }
        return list;
    }

    public static <P extends Jcl> List<JclRightPadded<P>> withElements(List<JclRightPadded<P>> before, List<P> elements) {
        if (elements.size() == before.size()) {
            boolean hasChanges = false;
            for (int i = 0; i < before.size(); ++i) {
                if (before.get(i).getElement() == elements.get(i)) continue;
                hasChanges = true;
                break;
            }
            if (!hasChanges) {
                return before;
            }
        }
        ArrayList<JclRightPadded<P>> after = new ArrayList<JclRightPadded<P>>(elements.size());
        Map beforeById = before.stream().collect(Collectors.toMap(j -> ((Jcl)j.getElement()).getId(), Function.identity()));
        for (Jcl t : elements) {
            if (beforeById.get(t.getId()) != null) {
                JclRightPadded found = (JclRightPadded)beforeById.get(t.getId());
                after.add(found.withElement(t));
                continue;
            }
            after.add(new JclRightPadded<Jcl>(t, Space.EMPTY, Markers.EMPTY));
        }
        return after;
    }

    public static <T> JclRightPadded<T> build(T element) {
        return new JclRightPadded<T>(element, Space.EMPTY, Markers.EMPTY);
    }

    @Nullable
    public static <T> JclRightPadded<T> withElement(@Nullable JclRightPadded<T> before, @Nullable T elements) {
        if (before == null) {
            if (elements == null) {
                return null;
            }
            return new JclRightPadded<T>(elements, Space.EMPTY, Markers.EMPTY);
        }
        if (elements == null) {
            return null;
        }
        return before.withElement(elements);
    }

    public String toString() {
        return "JclRightPadded(element=" + this.element.getClass().getSimpleName() + ", after=" + this.after + ')';
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JclRightPadded)) {
            return false;
        }
        JclRightPadded other = (JclRightPadded)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof JclRightPadded;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public JclRightPadded(T element, Space after, Markers markers) {
        this.element = element;
        this.after = after;
        this.markers = markers;
    }

    public T getElement() {
        return this.element;
    }

    public Space getAfter() {
        return this.after;
    }

    public Markers getMarkers() {
        return this.markers;
    }

    public JclRightPadded<T> withElement(T element) {
        return this.element == element ? this : new JclRightPadded<T>(element, this.after, this.markers);
    }

    public JclRightPadded<T> withAfter(Space after) {
        return this.after == after ? this : new JclRightPadded<T>(this.element, after, this.markers);
    }

    public JclRightPadded<T> withMarkers(Markers markers) {
        return this.markers == markers ? this : new JclRightPadded<T>(this.element, this.after, markers);
    }

    public static enum Location {
        TODO(Space.Location.TODO),
        PARAMETERS(Space.Location.PARAMETERS),
        PARENTHESES(Space.Location.PARENTHESES);

        private final Space.Location afterLocation;

        private Location(Space.Location afterLocation) {
            this.afterLocation = afterLocation;
        }

        public Space.Location getAfterLocation() {
            return this.afterLocation;
        }
    }
}

