/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jcl.tree;

import java.util.function.UnaryOperator;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.jcl.tree.Space;
import org.openrewrite.marker.Markers;

public final class JclLeftPadded<T> {
    private final Space before;
    private final T element;
    private final Markers markers;

    public JclLeftPadded<T> map(UnaryOperator<T> map) {
        return this.withElement(map.apply(this.element));
    }

    @Nullable
    public static <T> JclLeftPadded<T> withElement(@Nullable JclLeftPadded<T> before, @Nullable T elements) {
        if (before == null) {
            if (elements == null) {
                return null;
            }
            return new JclLeftPadded<T>(Space.EMPTY, elements, Markers.EMPTY);
        }
        if (elements == null) {
            return null;
        }
        return before.withElement(elements);
    }

    public String toString() {
        return "ProtoLeftPadded(before=" + this.before + ", element=" + this.element.getClass().getSimpleName() + ')';
    }

    public static <T> JclLeftPadded<T> build(T element) {
        return new JclLeftPadded<T>(Space.EMPTY, element, Markers.EMPTY);
    }

    public JclLeftPadded(Space before, T element, Markers markers) {
        this.before = before;
        this.element = element;
        this.markers = markers;
    }

    public Space getBefore() {
        return this.before;
    }

    public T getElement() {
        return this.element;
    }

    public Markers getMarkers() {
        return this.markers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof JclLeftPadded;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public JclLeftPadded<T> withBefore(Space before) {
        return this.before == before ? this : new JclLeftPadded<T>(before, this.element, this.markers);
    }

    public JclLeftPadded<T> withElement(T element) {
        return this.element == element ? this : new JclLeftPadded<T>(this.before, element, this.markers);
    }

    public JclLeftPadded<T> withMarkers(Markers markers) {
        return this.markers == markers ? this : new JclLeftPadded<T>(this.before, this.element, markers);
    }

    public static enum Location {
        ASSIGNMENT(Space.Location.ASSIGNMENT);

        private final Space.Location beforeLocation;

        private Location(Space.Location beforeLocation) {
            this.beforeLocation = beforeLocation;
        }

        public Space.Location getBeforeLocation() {
            return this.beforeLocation;
        }
    }
}

