/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jcl.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.jcl.tree.Jcl;
import org.openrewrite.jcl.tree.JclRightPadded;
import org.openrewrite.jcl.tree.Space;
import org.openrewrite.marker.Markers;

public class JclContainer<T> {
    private transient Padding<T> padding;
    private static final JclContainer<?> EMPTY = new JclContainer(Space.EMPTY, Collections.emptyList(), Markers.EMPTY);
    private final Space before;
    private final List<JclRightPadded<T>> elements;
    private final Markers markers;

    private JclContainer(Space before, List<JclRightPadded<T>> elements, Markers markers) {
        this.before = before;
        this.elements = elements;
        this.markers = markers;
    }

    public static <T> JclContainer<T> build(List<JclRightPadded<T>> elements) {
        return JclContainer.build(Space.EMPTY, elements, Markers.EMPTY);
    }

    @JsonCreator
    public static <T> JclContainer<T> build(Space before, List<JclRightPadded<T>> elements, Markers markers) {
        if (before.isEmpty() && elements.isEmpty()) {
            return JclContainer.empty();
        }
        return new JclContainer<T>(before, elements, markers);
    }

    public static <T> JclContainer<T> empty() {
        return EMPTY;
    }

    public JclContainer<T> withBefore(Space before) {
        return this.before == before ? this : JclContainer.build(before, this.elements, this.markers);
    }

    public JclContainer<T> withElements(List<JclRightPadded<T>> elements) {
        return this.elements == elements ? this : JclContainer.build(this.before, elements, this.markers);
    }

    public JclContainer<T> withMarkers(Markers markers) {
        return this.markers == markers ? this : JclContainer.build(this.before, this.elements, markers);
    }

    public Markers getMarkers() {
        return this.markers;
    }

    public List<T> getElements() {
        return JclRightPadded.getElements(this.elements);
    }

    public Space getBefore() {
        return this.before;
    }

    public JclContainer<T> map(UnaryOperator<T> map) {
        return this.getPadding().withElements(ListUtils.map(this.elements, t -> t.map(map)));
    }

    public Space getLastSpace() {
        return this.elements.isEmpty() ? Space.EMPTY : this.elements.get(this.elements.size() - 1).getAfter();
    }

    public JclContainer<T> withLastSpace(Space after) {
        return this.withElements(ListUtils.mapLast(this.elements, elem -> elem.withAfter(after)));
    }

    public Padding<T> getPadding() {
        if (this.padding == null) {
            this.padding = new Padding(this);
        }
        return this.padding;
    }

    @Nullable
    public static <P extends Jcl> JclContainer<P> withElementsNullable(@Nullable JclContainer<P> before, @Nullable List<P> elements) {
        if (before == null) {
            if (elements == null || elements.isEmpty()) {
                return null;
            }
            return JclContainer.build(Space.EMPTY, JclRightPadded.withElements(Collections.emptyList(), elements), Markers.EMPTY);
        }
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        return before.getPadding().withElements(JclRightPadded.withElements(before.elements, elements));
    }

    public static <P extends Jcl> JclContainer<P> withElements(JclContainer<P> before, @Nullable List<P> elements) {
        if (elements == null) {
            return before.getPadding().withElements(Collections.emptyList());
        }
        return before.getPadding().withElements(JclRightPadded.withElements(before.elements, elements));
    }

    public String toString() {
        return "JclContainer(before=" + this.before + ", elementCount=" + this.elements.size() + ')';
    }

    public static class Padding<T> {
        private final JclContainer<T> c;

        public List<JclRightPadded<T>> getElements() {
            return ((JclContainer)this.c).elements;
        }

        public JclContainer<T> withElements(List<JclRightPadded<T>> elements) {
            return ((JclContainer)this.c).elements == elements ? this.c : JclContainer.build(((JclContainer)this.c).before, elements, ((JclContainer)this.c).markers);
        }

        public Padding(JclContainer<T> c) {
            this.c = c;
        }
    }

    public static enum Location {
        TODO(Space.Location.TODO, JclRightPadded.Location.TODO),
        PARAMETERS(Space.Location.PARAMETERS, JclRightPadded.Location.PARAMETERS);

        private final Space.Location beforeLocation;
        private final JclRightPadded.Location elementLocation;

        private Location(Space.Location beforeLocation, JclRightPadded.Location elementLocation) {
            this.beforeLocation = beforeLocation;
            this.elementLocation = elementLocation;
        }

        public Space.Location getBeforeLocation() {
            return this.beforeLocation;
        }

        public JclRightPadded.Location getElementLocation() {
            return this.elementLocation;
        }
    }
}

