/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jcl.tree;

import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.jcl.JclVisitor;
import org.openrewrite.jcl.internal.JclPrinter;
import org.openrewrite.jcl.tree.Expression;
import org.openrewrite.jcl.tree.JclContainer;
import org.openrewrite.jcl.tree.JclLeftPadded;
import org.openrewrite.jcl.tree.JclRightPadded;
import org.openrewrite.jcl.tree.Name;
import org.openrewrite.jcl.tree.Parameter;
import org.openrewrite.jcl.tree.Space;
import org.openrewrite.jcl.tree.Statement;
import org.openrewrite.marker.Markers;

public interface Jcl
extends Tree {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptJcl((JclVisitor)v.adapt(JclVisitor.class), p);
    }

    @Nullable
    default public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
        return (Jcl)v.defaultValue(this, p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(JclVisitor.class);
    }

    public Space getPrefix();

    public <P extends Jcl> P withPrefix(Space var1);

    public static final class Unsupported
    implements Jcl,
    Statement,
    Parameter,
    Expression,
    Name {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final String text;

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitUnsupported(this, p);
        }

        public Unsupported(UUID id, Space prefix, Markers markers, String text) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.text = text;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return "Jcl.Unsupported(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", text=" + this.getText() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Unsupported)) {
                return false;
            }
            Unsupported other = (Unsupported)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Unsupported withId(UUID id) {
            return this.id == id ? this : new Unsupported(id, this.prefix, this.markers, this.text);
        }

        public Unsupported withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Unsupported(this.id, prefix, this.markers, this.text);
        }

        public Unsupported withMarkers(Markers markers) {
            return this.markers == markers ? this : new Unsupported(this.id, this.prefix, markers, this.text);
        }

        public Unsupported withText(String text) {
            return this.text == text ? this : new Unsupported(this.id, this.prefix, this.markers, text);
        }
    }

    public static class XmitStatement
    implements Jcl,
    Parameter {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Name name;
        private final JclContainer<Parameter> parameters;

        public List<Parameter> getParameters() {
            return this.parameters.getElements();
        }

        public XmitStatement withParameters(List<Parameter> parameters) {
            return this.getPadding().withParameters(Objects.requireNonNull(JclContainer.withElementsNullable(this.parameters, parameters)));
        }

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitXmitStatement(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof XmitStatement)) {
                return false;
            }
            XmitStatement other = (XmitStatement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof XmitStatement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public XmitStatement(UUID id, Space prefix, Markers markers, Name name, JclContainer<Parameter> parameters) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.parameters = parameters;
        }

        private XmitStatement(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Name name, JclContainer<Parameter> parameters) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.parameters = parameters;
        }

        public XmitStatement withId(UUID id) {
            return this.id == id ? this : new XmitStatement(this.padding, id, this.prefix, this.markers, this.name, this.parameters);
        }

        public UUID getId() {
            return this.id;
        }

        public XmitStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new XmitStatement(this.padding, this.id, prefix, this.markers, this.name, this.parameters);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public XmitStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new XmitStatement(this.padding, this.id, this.prefix, markers, this.name, this.parameters);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public XmitStatement withName(Name name) {
            return this.name == name ? this : new XmitStatement(this.padding, this.id, this.prefix, this.markers, name, this.parameters);
        }

        public Name getName() {
            return this.name;
        }

        public static class Padding {
            private final XmitStatement t;

            public JclContainer<Parameter> getParameters() {
                return this.t.parameters;
            }

            public XmitStatement withParameters(JclContainer<Parameter> parameters) {
                return this.t.parameters == parameters ? this.t : new XmitStatement(this.t.id, this.t.prefix, this.t.markers, this.t.name, parameters);
            }

            public Padding(XmitStatement t) {
                this.t = t;
            }
        }
    }

    public static class SetStatement
    implements Jcl,
    Parameter {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Name name;
        private final JclContainer<Parameter> parameters;

        public List<Parameter> getParameters() {
            return this.parameters.getElements();
        }

        public SetStatement withParameters(List<Parameter> parameters) {
            return this.getPadding().withParameters(Objects.requireNonNull(JclContainer.withElementsNullable(this.parameters, parameters)));
        }

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitSetStatement(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SetStatement)) {
                return false;
            }
            SetStatement other = (SetStatement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SetStatement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public SetStatement(UUID id, Space prefix, Markers markers, Name name, JclContainer<Parameter> parameters) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.parameters = parameters;
        }

        private SetStatement(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Name name, JclContainer<Parameter> parameters) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.parameters = parameters;
        }

        public SetStatement withId(UUID id) {
            return this.id == id ? this : new SetStatement(this.padding, id, this.prefix, this.markers, this.name, this.parameters);
        }

        public UUID getId() {
            return this.id;
        }

        public SetStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SetStatement(this.padding, this.id, prefix, this.markers, this.name, this.parameters);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public SetStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new SetStatement(this.padding, this.id, this.prefix, markers, this.name, this.parameters);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public SetStatement withName(Name name) {
            return this.name == name ? this : new SetStatement(this.padding, this.id, this.prefix, this.markers, name, this.parameters);
        }

        public Name getName() {
            return this.name;
        }

        public static class Padding {
            private final SetStatement t;

            public JclContainer<Parameter> getParameters() {
                return this.t.parameters;
            }

            public SetStatement withParameters(JclContainer<Parameter> parameters) {
                return this.t.parameters == parameters ? this.t : new SetStatement(this.t.id, this.t.prefix, this.t.markers, this.t.name, parameters);
            }

            public Padding(SetStatement t) {
                this.t = t;
            }
        }
    }

    public static class ProcStatement
    implements Jcl,
    Parameter {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Name name;
        private final JclContainer<Parameter> parameters;

        public List<Parameter> getParameters() {
            return this.parameters.getElements();
        }

        public ProcStatement withParameters(List<Parameter> parameters) {
            return this.getPadding().withParameters(Objects.requireNonNull(JclContainer.withElementsNullable(this.parameters, parameters)));
        }

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitProcStatement(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcStatement)) {
                return false;
            }
            ProcStatement other = (ProcStatement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProcStatement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ProcStatement(UUID id, Space prefix, Markers markers, Name name, JclContainer<Parameter> parameters) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.parameters = parameters;
        }

        private ProcStatement(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Name name, JclContainer<Parameter> parameters) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.parameters = parameters;
        }

        public ProcStatement withId(UUID id) {
            return this.id == id ? this : new ProcStatement(this.padding, id, this.prefix, this.markers, this.name, this.parameters);
        }

        public UUID getId() {
            return this.id;
        }

        public ProcStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ProcStatement(this.padding, this.id, prefix, this.markers, this.name, this.parameters);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public ProcStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new ProcStatement(this.padding, this.id, this.prefix, markers, this.name, this.parameters);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ProcStatement withName(Name name) {
            return this.name == name ? this : new ProcStatement(this.padding, this.id, this.prefix, this.markers, name, this.parameters);
        }

        public Name getName() {
            return this.name;
        }

        public static class Padding {
            private final ProcStatement t;

            public JclContainer<Parameter> getParameters() {
                return this.t.parameters;
            }

            public ProcStatement withParameters(JclContainer<Parameter> parameters) {
                return this.t.parameters == parameters ? this.t : new ProcStatement(this.t.id, this.t.prefix, this.t.markers, this.t.name, parameters);
            }

            public Padding(ProcStatement t) {
                this.t = t;
            }
        }
    }

    public static final class Pend
    implements Jcl,
    Parameter {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Name name;

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitPend(this, p);
        }

        public Pend(UUID id, Space prefix, Markers markers, Name name) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Name getName() {
            return this.name;
        }

        public String toString() {
            return "Jcl.Pend(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pend)) {
                return false;
            }
            Pend other = (Pend)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Pend withId(UUID id) {
            return this.id == id ? this : new Pend(id, this.prefix, this.markers, this.name);
        }

        public Pend withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Pend(this.id, prefix, this.markers, this.name);
        }

        public Pend withMarkers(Markers markers) {
            return this.markers == markers ? this : new Pend(this.id, this.prefix, markers, this.name);
        }

        public Pend withName(Name name) {
            return this.name == name ? this : new Pend(this.id, this.prefix, this.markers, name);
        }
    }

    public static class Parentheses<J2 extends Jcl>
    implements Jcl,
    Expression,
    Parameter {
        @Nullable
        private transient WeakReference<Padding<J2>> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<JclRightPadded<J2>> trees;

        public List<J2> getTrees() {
            return JclRightPadded.getElements(this.trees);
        }

        Parentheses<J2> withTrees(List<J2> trees) {
            return this.getPadding().withTrees(JclRightPadded.withElements(this.trees, trees));
        }

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitParentheses(this, p);
        }

        public Padding<J2> getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parentheses)) {
                return false;
            }
            Parentheses other = (Parentheses)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Parentheses;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Parentheses(UUID id, Space prefix, Markers markers, List<JclRightPadded<J2>> trees) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.trees = trees;
        }

        private Parentheses(WeakReference<Padding<J2>> padding, UUID id, Space prefix, Markers markers, List<JclRightPadded<J2>> trees) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.trees = trees;
        }

        public Parentheses<J2> withId(UUID id) {
            return this.id == id ? this : new Parentheses<J2>(this.padding, id, this.prefix, this.markers, this.trees);
        }

        public UUID getId() {
            return this.id;
        }

        public Parentheses<J2> withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Parentheses<J2>(this.padding, this.id, prefix, this.markers, this.trees);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Parentheses<J2> withMarkers(Markers markers) {
            return this.markers == markers ? this : new Parentheses<J2>(this.padding, this.id, this.prefix, markers, this.trees);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding<J2 extends Jcl> {
            private final Parentheses<J2> t;

            public List<JclRightPadded<J2>> getTrees() {
                return ((Parentheses)this.t).trees;
            }

            public Parentheses<J2> withTrees(List<JclRightPadded<J2>> trees) {
                return ((Parentheses)this.t).trees == trees ? this.t : new Parentheses<J2>(((Parentheses)this.t).id, ((Parentheses)this.t).prefix, ((Parentheses)this.t).markers, trees);
            }

            public Padding(Parentheses<J2> t) {
                this.t = t;
            }
        }
    }

    public static class OutputStatement
    implements Jcl,
    Parameter {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Name name;
        private final JclContainer<Parameter> parameters;

        public List<Parameter> getParameters() {
            return this.parameters.getElements();
        }

        public OutputStatement withParameters(List<Parameter> parameters) {
            return this.getPadding().withParameters(Objects.requireNonNull(JclContainer.withElementsNullable(this.parameters, parameters)));
        }

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitOutputStatement(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OutputStatement)) {
                return false;
            }
            OutputStatement other = (OutputStatement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OutputStatement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public OutputStatement(UUID id, Space prefix, Markers markers, Name name, JclContainer<Parameter> parameters) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.parameters = parameters;
        }

        private OutputStatement(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Name name, JclContainer<Parameter> parameters) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.parameters = parameters;
        }

        public OutputStatement withId(UUID id) {
            return this.id == id ? this : new OutputStatement(this.padding, id, this.prefix, this.markers, this.name, this.parameters);
        }

        public UUID getId() {
            return this.id;
        }

        public OutputStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new OutputStatement(this.padding, this.id, prefix, this.markers, this.name, this.parameters);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public OutputStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new OutputStatement(this.padding, this.id, this.prefix, markers, this.name, this.parameters);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public OutputStatement withName(Name name) {
            return this.name == name ? this : new OutputStatement(this.padding, this.id, this.prefix, this.markers, name, this.parameters);
        }

        public Name getName() {
            return this.name;
        }

        public static class Padding {
            private final OutputStatement t;

            public JclContainer<Parameter> getParameters() {
                return this.t.parameters;
            }

            public OutputStatement withParameters(JclContainer<Parameter> parameters) {
                return this.t.parameters == parameters ? this.t : new OutputStatement(this.t.id, this.t.prefix, this.t.markers, this.t.name, parameters);
            }

            public Padding(OutputStatement t) {
                this.t = t;
            }
        }
    }

    public static final class JclName
    implements Jcl,
    Expression,
    Name {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Identifier name;
        @Nullable
        private final Parentheses<JclName> parentheses;

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitJclName(this, p);
        }

        public JclName(UUID id, Space prefix, Markers markers, Identifier name, Parentheses<JclName> parentheses) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.parentheses = parentheses;
        }

        public Identifier getName() {
            return this.name;
        }

        public Parentheses<JclName> getParentheses() {
            return this.parentheses;
        }

        public String toString() {
            return "Jcl.JclName(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", parentheses=" + this.getParentheses() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JclName)) {
                return false;
            }
            JclName other = (JclName)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public JclName withId(UUID id) {
            return this.id == id ? this : new JclName(id, this.prefix, this.markers, this.name, this.parentheses);
        }

        public JclName withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new JclName(this.id, prefix, this.markers, this.name, this.parentheses);
        }

        public JclName withMarkers(Markers markers) {
            return this.markers == markers ? this : new JclName(this.id, this.prefix, markers, this.name, this.parentheses);
        }

        public JclName withName(Identifier name) {
            return this.name == name ? this : new JclName(this.id, this.prefix, this.markers, name, this.parentheses);
        }

        public JclName withParentheses(Parentheses<JclName> parentheses) {
            return this.parentheses == parentheses ? this : new JclName(this.id, this.prefix, this.markers, this.name, parentheses);
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }
    }

    public static final class Literal
    implements Jcl,
    Parameter,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final Object value;
        @Nullable
        private final String valueSource;

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitLiteral(this, p);
        }

        public Literal(UUID id, Space prefix, Markers markers, Object value, String valueSource) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.value = value;
            this.valueSource = valueSource;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Object getValue() {
            return this.value;
        }

        public String getValueSource() {
            return this.valueSource;
        }

        public String toString() {
            return "Jcl.Literal(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", value=" + this.getValue() + ", valueSource=" + this.getValueSource() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Literal)) {
                return false;
            }
            Literal other = (Literal)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Literal withId(UUID id) {
            return this.id == id ? this : new Literal(id, this.prefix, this.markers, this.value, this.valueSource);
        }

        public Literal withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Literal(this.id, prefix, this.markers, this.value, this.valueSource);
        }

        public Literal withMarkers(Markers markers) {
            return this.markers == markers ? this : new Literal(this.id, this.prefix, markers, this.value, this.valueSource);
        }

        public Literal withValue(Object value) {
            return this.value == value ? this : new Literal(this.id, this.prefix, this.markers, value, this.valueSource);
        }

        public Literal withValueSource(String valueSource) {
            return this.valueSource == valueSource ? this : new Literal(this.id, this.prefix, this.markers, this.value, valueSource);
        }
    }

    public static class JobStatement
    implements Jcl {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Name name;
        private final JclContainer<Parameter> parameters;

        public List<Parameter> getParameters() {
            return this.parameters.getElements();
        }

        public JobStatement withParameters(List<Parameter> parameters) {
            return this.getPadding().withParameters(Objects.requireNonNull(JclContainer.withElementsNullable(this.parameters, parameters)));
        }

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitJobStatement(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JobStatement)) {
                return false;
            }
            JobStatement other = (JobStatement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JobStatement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public JobStatement(UUID id, Space prefix, Markers markers, Name name, JclContainer<Parameter> parameters) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.parameters = parameters;
        }

        private JobStatement(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Name name, JclContainer<Parameter> parameters) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.parameters = parameters;
        }

        public JobStatement withId(UUID id) {
            return this.id == id ? this : new JobStatement(this.padding, id, this.prefix, this.markers, this.name, this.parameters);
        }

        public UUID getId() {
            return this.id;
        }

        public JobStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new JobStatement(this.padding, this.id, prefix, this.markers, this.name, this.parameters);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public JobStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new JobStatement(this.padding, this.id, this.prefix, markers, this.name, this.parameters);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public JobStatement withName(Name name) {
            return this.name == name ? this : new JobStatement(this.padding, this.id, this.prefix, this.markers, name, this.parameters);
        }

        public Name getName() {
            return this.name;
        }

        public static class Padding {
            private final JobStatement t;

            public JclContainer<Parameter> getParameters() {
                return this.t.parameters;
            }

            public JobStatement withParameters(JclContainer<Parameter> parameters) {
                return this.t.parameters == parameters ? this.t : new JobStatement(this.t.id, this.t.prefix, this.t.markers, this.t.name, parameters);
            }

            public Padding(JobStatement t) {
                this.t = t;
            }
        }
    }

    public static final class JclStatement
    implements Jcl,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Name name;
        private final Jcl statement;

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitJclStatement(this, p);
        }

        public JclStatement(UUID id, Space prefix, Markers markers, Name name, Jcl statement) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.statement = statement;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Name getName() {
            return this.name;
        }

        public Jcl getStatement() {
            return this.statement;
        }

        public String toString() {
            return "Jcl.JclStatement(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", statement=" + this.getStatement() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JclStatement)) {
                return false;
            }
            JclStatement other = (JclStatement)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public JclStatement withId(UUID id) {
            return this.id == id ? this : new JclStatement(id, this.prefix, this.markers, this.name, this.statement);
        }

        public JclStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new JclStatement(this.id, prefix, this.markers, this.name, this.statement);
        }

        public JclStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new JclStatement(this.id, this.prefix, markers, this.name, this.statement);
        }

        public JclStatement withName(Name name) {
            return this.name == name ? this : new JclStatement(this.id, this.prefix, this.markers, name, this.statement);
        }

        public JclStatement withStatement(Jcl statement) {
            return this.statement == statement ? this : new JclStatement(this.id, this.prefix, this.markers, this.name, statement);
        }
    }

    public static class ExecStatement
    implements Jcl {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Name name;
        private final JclContainer<Parameter> parameters;

        public List<Parameter> getParameters() {
            return this.parameters.getElements();
        }

        public ExecStatement withParameters(List<Parameter> parameters) {
            return this.getPadding().withParameters(Objects.requireNonNull(JclContainer.withElementsNullable(this.parameters, parameters)));
        }

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitExecStatement(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExecStatement)) {
                return false;
            }
            ExecStatement other = (ExecStatement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExecStatement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public ExecStatement(UUID id, Space prefix, Markers markers, Name name, JclContainer<Parameter> parameters) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.parameters = parameters;
        }

        private ExecStatement(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Name name, JclContainer<Parameter> parameters) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.parameters = parameters;
        }

        public ExecStatement withId(UUID id) {
            return this.id == id ? this : new ExecStatement(this.padding, id, this.prefix, this.markers, this.name, this.parameters);
        }

        public UUID getId() {
            return this.id;
        }

        public ExecStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ExecStatement(this.padding, this.id, prefix, this.markers, this.name, this.parameters);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public ExecStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new ExecStatement(this.padding, this.id, this.prefix, markers, this.name, this.parameters);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public ExecStatement withName(Name name) {
            return this.name == name ? this : new ExecStatement(this.padding, this.id, this.prefix, this.markers, name, this.parameters);
        }

        public Name getName() {
            return this.name;
        }

        public static class Padding {
            private final ExecStatement t;

            public JclContainer<Parameter> getParameters() {
                return this.t.parameters;
            }

            public ExecStatement withParameters(JclContainer<Parameter> parameters) {
                return this.t.parameters == parameters ? this.t : new ExecStatement(this.t.id, this.t.prefix, this.t.markers, this.t.name, parameters);
            }

            public Padding(ExecStatement t) {
                this.t = t;
            }
        }
    }

    public static class DataDefinitionStatement
    implements Jcl {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Name name;
        private final JclContainer<Parameter> parameters;

        public List<Parameter> getParameters() {
            return this.parameters.getElements();
        }

        public DataDefinitionStatement withParameters(List<Parameter> parameters) {
            return this.getPadding().withParameters(Objects.requireNonNull(JclContainer.withElementsNullable(this.parameters, parameters)));
        }

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitDataDefinitionStatement(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataDefinitionStatement)) {
                return false;
            }
            DataDefinitionStatement other = (DataDefinitionStatement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DataDefinitionStatement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public DataDefinitionStatement(UUID id, Space prefix, Markers markers, Name name, JclContainer<Parameter> parameters) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.parameters = parameters;
        }

        private DataDefinitionStatement(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Name name, JclContainer<Parameter> parameters) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.parameters = parameters;
        }

        public DataDefinitionStatement withId(UUID id) {
            return this.id == id ? this : new DataDefinitionStatement(this.padding, id, this.prefix, this.markers, this.name, this.parameters);
        }

        public UUID getId() {
            return this.id;
        }

        public DataDefinitionStatement withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new DataDefinitionStatement(this.padding, this.id, prefix, this.markers, this.name, this.parameters);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public DataDefinitionStatement withMarkers(Markers markers) {
            return this.markers == markers ? this : new DataDefinitionStatement(this.padding, this.id, this.prefix, markers, this.name, this.parameters);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public DataDefinitionStatement withName(Name name) {
            return this.name == name ? this : new DataDefinitionStatement(this.padding, this.id, this.prefix, this.markers, name, this.parameters);
        }

        public Name getName() {
            return this.name;
        }

        public static class Padding {
            private final DataDefinitionStatement t;

            public JclContainer<Parameter> getParameters() {
                return this.t.parameters;
            }

            public DataDefinitionStatement withParameters(JclContainer<Parameter> parameters) {
                return this.t.parameters == parameters ? this.t : new DataDefinitionStatement(this.t.id, this.t.prefix, this.t.markers, this.t.name, parameters);
            }

            public Padding(DataDefinitionStatement t) {
                this.t = t;
            }
        }
    }

    public static final class Identifier
    implements Jcl,
    Expression,
    Name {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final String simpleName;

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitIdentifier(this, p);
        }

        public Identifier(UUID id, Space prefix, Markers markers, String simpleName) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.simpleName = simpleName;
        }

        public String getSimpleName() {
            return this.simpleName;
        }

        public String toString() {
            return "Jcl.Identifier(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", simpleName=" + this.getSimpleName() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Identifier)) {
                return false;
            }
            Identifier other = (Identifier)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Identifier withId(UUID id) {
            return this.id == id ? this : new Identifier(id, this.prefix, this.markers, this.simpleName);
        }

        public Identifier withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Identifier(this.id, prefix, this.markers, this.simpleName);
        }

        public Identifier withMarkers(Markers markers) {
            return this.markers == markers ? this : new Identifier(this.id, this.prefix, markers, this.simpleName);
        }

        public Identifier withSimpleName(String simpleName) {
            return this.simpleName == simpleName ? this : new Identifier(this.id, this.prefix, this.markers, simpleName);
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }
    }

    public static class Assignment
    implements Jcl,
    Parameter,
    Expression {
        @Nullable
        private transient WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression variable;
        private final JclLeftPadded<Expression> assignment;

        public Expression getAssignment() {
            return this.assignment.getElement();
        }

        public Assignment withAssignment(Expression assignment) {
            return this.getPadding().withAssignment(this.assignment.withElement(assignment));
        }

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitAssignment(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Assignment)) {
                return false;
            }
            Assignment other = (Assignment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Assignment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Assignment(UUID id, Space prefix, Markers markers, Expression variable, JclLeftPadded<Expression> assignment) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.variable = variable;
            this.assignment = assignment;
        }

        private Assignment(WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression variable, JclLeftPadded<Expression> assignment) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.variable = variable;
            this.assignment = assignment;
        }

        public Assignment withId(UUID id) {
            return this.id == id ? this : new Assignment(this.padding, id, this.prefix, this.markers, this.variable, this.assignment);
        }

        public UUID getId() {
            return this.id;
        }

        public Assignment withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Assignment(this.padding, this.id, prefix, this.markers, this.variable, this.assignment);
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Assignment withMarkers(Markers markers) {
            return this.markers == markers ? this : new Assignment(this.padding, this.id, this.prefix, markers, this.variable, this.assignment);
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public Assignment withVariable(Expression variable) {
            return this.variable == variable ? this : new Assignment(this.padding, this.id, this.prefix, this.markers, variable, this.assignment);
        }

        public Expression getVariable() {
            return this.variable;
        }

        public static class Padding {
            private final Assignment t;

            public JclLeftPadded<Expression> getAssignment() {
                return this.t.assignment;
            }

            public Assignment withAssignment(JclLeftPadded<Expression> assignment) {
                return this.t.assignment == assignment ? this.t : new Assignment(this.t.id, this.t.prefix, this.t.markers, this.t.variable, assignment);
            }

            public Padding(Assignment t) {
                this.t = t;
            }
        }
    }

    public static final class CompilationUnit
    implements Jcl,
    SourceFile {
        private final UUID id;
        private final Path sourcePath;
        @Nullable
        private final FileAttributes fileAttributes;
        private final Space prefix;
        private final Markers markers;
        @Nullable
        private final String charsetName;
        private final boolean charsetBomMarked;
        @Nullable
        private final Checksum checksum;
        private final List<Statement> statements;
        private final Space eof;

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        @Override
        public <P> Jcl acceptJcl(JclVisitor<P> v, P p) {
            return v.visitCompilationUnit(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new JclPrinter();
        }

        public CompilationUnit(UUID id, Path sourcePath, FileAttributes fileAttributes, Space prefix, Markers markers, String charsetName, boolean charsetBomMarked, Checksum checksum, List<Statement> statements, Space eof) {
            this.id = id;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.prefix = prefix;
            this.markers = markers;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.statements = statements;
            this.eof = eof;
        }

        public UUID getId() {
            return this.id;
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        public FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        @Override
        public Space getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getCharsetName() {
            return this.charsetName;
        }

        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        public Checksum getChecksum() {
            return this.checksum;
        }

        public List<Statement> getStatements() {
            return this.statements;
        }

        public Space getEof() {
            return this.eof;
        }

        public String toString() {
            return "Jcl.CompilationUnit(id=" + this.getId() + ", sourcePath=" + this.getSourcePath() + ", fileAttributes=" + this.getFileAttributes() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", charsetName=" + this.getCharsetName() + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", checksum=" + this.getChecksum() + ", statements=" + this.getStatements() + ", eof=" + this.getEof() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnit)) {
                return false;
            }
            CompilationUnit other = (CompilationUnit)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public CompilationUnit withId(UUID id) {
            return this.id == id ? this : new CompilationUnit(id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.statements, this.eof);
        }

        public CompilationUnit withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new CompilationUnit(this.id, sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.statements, this.eof);
        }

        public CompilationUnit withFileAttributes(FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new CompilationUnit(this.id, this.sourcePath, fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.statements, this.eof);
        }

        public CompilationUnit withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CompilationUnit(this.id, this.sourcePath, this.fileAttributes, prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.statements, this.eof);
        }

        public CompilationUnit withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilationUnit(this.id, this.sourcePath, this.fileAttributes, this.prefix, markers, this.charsetName, this.charsetBomMarked, this.checksum, this.statements, this.eof);
        }

        public CompilationUnit withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new CompilationUnit(this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, charsetBomMarked, this.checksum, this.statements, this.eof);
        }

        public CompilationUnit withChecksum(Checksum checksum) {
            return this.checksum == checksum ? this : new CompilationUnit(this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, checksum, this.statements, this.eof);
        }

        public CompilationUnit withStatements(List<Statement> statements) {
            return this.statements == statements ? this : new CompilationUnit(this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, statements, this.eof);
        }

        public CompilationUnit withEof(Space eof) {
            return this.eof == eof ? this : new CompilationUnit(this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.statements, eof);
        }

        private CompilationUnit withCharsetName(String charsetName) {
            return this.charsetName == charsetName ? this : new CompilationUnit(this.id, this.sourcePath, this.fileAttributes, this.prefix, this.markers, charsetName, this.charsetBomMarked, this.checksum, this.statements, this.eof);
        }
    }
}

