/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jcl.internal;

import java.util.List;
import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.jcl.JclVisitor;
import org.openrewrite.jcl.markers.OmitFirstParam;
import org.openrewrite.jcl.tree.Jcl;
import org.openrewrite.jcl.tree.JclContainer;
import org.openrewrite.jcl.tree.JclLeftPadded;
import org.openrewrite.jcl.tree.JclRightPadded;
import org.openrewrite.jcl.tree.Space;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class JclPrinter<P>
extends JclVisitor<PrintOutputCapture<P>> {
    public static final UnaryOperator<String> JCL_MARKER_WRAPPER = out -> "~~" + out + (out.isEmpty() ? "" : "~~") + ">";

    public Jcl.CompilationUnit visitCompilationUnit(Jcl.CompilationUnit cu, PrintOutputCapture<P> p) {
        this.beforeSyntax(cu, Space.Location.COMPILATION_UNIT_PREFIX, p);
        this.visit(cu.getStatements(), p);
        this.afterSyntax(cu, p);
        this.visitSpace(cu.getEof(), Space.Location.COMPILATION_UNIT_EOF, p);
        return cu;
    }

    @Override
    public Jcl visitAssignment(Jcl.Assignment assignment, PrintOutputCapture<P> p) {
        this.beforeSyntax(assignment, Space.Location.ASSIGNMENT_PREFIX, p);
        this.visit(assignment.getVariable(), p);
        this.visitLeftPadded("=", assignment.getPadding().getAssignment(), JclLeftPadded.Location.ASSIGNMENT, p);
        this.afterSyntax(assignment, p);
        return assignment;
    }

    @Override
    public Jcl visitDataDefinitionStatement(Jcl.DataDefinitionStatement dataDefinitionStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(dataDefinitionStatement, Space.Location.DATA_DEFINITION_STATEMENT_PREFIX, p);
        this.visit(dataDefinitionStatement.getName(), p);
        this.visitContainer("", dataDefinitionStatement.getPadding().getParameters(), JclContainer.Location.PARAMETERS, ",", "", p);
        this.afterSyntax(dataDefinitionStatement, p);
        return dataDefinitionStatement;
    }

    @Override
    public Jcl visitExecStatement(Jcl.ExecStatement execStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(execStatement, Space.Location.EXEC_STATEMENT_PREFIX, p);
        this.visit(execStatement.getName(), p);
        this.visitContainer("", execStatement.getPadding().getParameters(), JclContainer.Location.PARAMETERS, ",", "", p);
        this.afterSyntax(execStatement, p);
        return execStatement;
    }

    @Override
    public Jcl visitIdentifier(Jcl.Identifier identifier, PrintOutputCapture<P> p) {
        this.beforeSyntax(identifier, Space.Location.IDENTIFIER_PREFIX, p);
        p.append(identifier.getSimpleName());
        this.afterSyntax(identifier, p);
        return identifier;
    }

    @Override
    public Jcl visitJclName(Jcl.JclName jclName, PrintOutputCapture<P> p) {
        this.beforeSyntax(jclName, Space.Location.JCL_NAME_PREFIX, p);
        this.visit(jclName.getName(), p);
        this.visit(jclName.getParentheses(), p);
        this.afterSyntax(jclName, p);
        return jclName;
    }

    @Override
    public Jcl visitJclStatement(Jcl.JclStatement jclStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(jclStatement, Space.Location.JCL_STATEMENT_PREFIX, p);
        p.append("//");
        this.visit(jclStatement.getName(), p);
        this.visit(jclStatement.getStatement(), p);
        this.afterSyntax(jclStatement, p);
        return jclStatement;
    }

    @Override
    public Jcl visitJobStatement(Jcl.JobStatement jobStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(jobStatement, Space.Location.JOB_STATEMENT_PREFIX, p);
        this.visit(jobStatement.getName(), p);
        this.visitContainer("", jobStatement.getPadding().getParameters(), JclContainer.Location.PARAMETERS, ",", "", p);
        this.afterSyntax(jobStatement, p);
        return jobStatement;
    }

    @Override
    public Jcl visitLiteral(Jcl.Literal literal, PrintOutputCapture<P> p) {
        this.beforeSyntax(literal, Space.Location.LITERAL_PREFIX, p);
        p.append(literal.getValueSource());
        this.afterSyntax(literal, p);
        return literal;
    }

    @Override
    public Jcl visitOutputStatement(Jcl.OutputStatement outputStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(outputStatement, Space.Location.OUTPUT_STATEMENT_PREFIX, p);
        this.visit(outputStatement.getName(), p);
        this.visitContainer("", outputStatement.getPadding().getParameters(), JclContainer.Location.PARAMETERS, ",", "", p);
        this.afterSyntax(outputStatement, p);
        return outputStatement;
    }

    @Override
    public <T extends Jcl> Jcl visitParentheses(Jcl.Parentheses<T> parentheses, PrintOutputCapture<P> p) {
        this.beforeSyntax(parentheses, Space.Location.PARENTHESES_PREFIX, p);
        p.append("(");
        if (parentheses.getMarkers().findFirst(OmitFirstParam.class).isPresent()) {
            p.append(",");
        }
        this.visitRightPadded(parentheses.getPadding().getTrees(), JclRightPadded.Location.PARENTHESES, ",", p);
        p.append(")");
        this.afterSyntax(parentheses, p);
        return parentheses;
    }

    @Override
    public Jcl visitPend(Jcl.Pend pend, PrintOutputCapture<P> p) {
        this.beforeSyntax(pend, Space.Location.PEND_PREFIX, p);
        this.visit(pend.getName(), p);
        this.afterSyntax(pend, p);
        return pend;
    }

    @Override
    public Jcl visitProcStatement(Jcl.ProcStatement procStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(procStatement, Space.Location.PROC_STATEMENT_PREFIX, p);
        this.visit(procStatement.getName(), p);
        this.visitContainer("", procStatement.getPadding().getParameters(), JclContainer.Location.PARAMETERS, ",", "", p);
        this.afterSyntax(procStatement, p);
        return procStatement;
    }

    @Override
    public Jcl visitSetStatement(Jcl.SetStatement setStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(setStatement, Space.Location.SET_STATEMENT_PREFIX, p);
        this.visit(setStatement.getName(), p);
        this.visitContainer("", setStatement.getPadding().getParameters(), JclContainer.Location.PARAMETERS, ",", "", p);
        this.afterSyntax(setStatement, p);
        return setStatement;
    }

    @Override
    public Jcl visitXmitStatement(Jcl.XmitStatement xmitStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax(xmitStatement, Space.Location.XMIT_STATEMENT_PREFIX, p);
        this.visit(xmitStatement.getName(), p);
        this.visitContainer("", xmitStatement.getPadding().getParameters(), JclContainer.Location.PARAMETERS, ",", "", p);
        this.afterSyntax(xmitStatement, p);
        return xmitStatement;
    }

    @Override
    public Jcl visitUnsupported(Jcl.Unsupported unsupported, PrintOutputCapture<P> p) {
        this.beforeSyntax(unsupported, Space.Location.UNSUPPORTED_PREFIX, p);
        p.append(unsupported.getText());
        this.afterSyntax(unsupported, p);
        return unsupported;
    }

    @Override
    public Space visitSpace(Space space, Space.Location location, PrintOutputCapture<P> p) {
        if (space.isContinued().booleanValue()) {
            p.append("//");
        }
        p.append(space.getWhitespace());
        return space;
    }

    protected void visitContainer(String before, @Nullable JclContainer<? extends Jcl> container, JclContainer.Location location, String suffixBetween, @Nullable String after, PrintOutputCapture<P> p) {
        if (container == null) {
            return;
        }
        this.beforeSyntax(container.getBefore(), container.getMarkers(), location.getBeforeLocation(), p);
        p.append(before);
        if (container.getMarkers().findFirst(OmitFirstParam.class).isPresent()) {
            p.append(",");
        }
        this.visitRightPadded(container.getPadding().getElements(), location.getElementLocation(), suffixBetween, p);
        this.afterSyntax(container.getMarkers(), p);
        p.append(after == null ? "" : after);
    }

    protected void visitLeftPadded(@Nullable String prefix, @Nullable JclLeftPadded<? extends Jcl> leftPadded, JclLeftPadded.Location location, PrintOutputCapture<P> p) {
        if (leftPadded != null) {
            this.beforeSyntax(leftPadded.getBefore(), leftPadded.getMarkers(), location.getBeforeLocation(), p);
            if (prefix != null) {
                p.append(prefix);
            }
            this.visit(leftPadded.getElement(), p);
            this.afterSyntax(leftPadded.getMarkers(), p);
        }
    }

    protected void visitRightPadded(List<? extends JclRightPadded<? extends Jcl>> nodes, JclRightPadded.Location location, String suffixBetween, PrintOutputCapture<P> p) {
        for (int i = 0; i < nodes.size(); ++i) {
            JclRightPadded<? extends Jcl> node = nodes.get(i);
            this.visit(node.getElement(), p);
            this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
            this.visitMarkers(node.getMarkers(), p);
            if (i >= nodes.size() - 1) continue;
            p.append(suffixBetween);
        }
    }

    protected void beforeSyntax(Jcl c, Space.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(c.getPrefix(), c.getMarkers(), loc, p);
    }

    protected void beforeSyntax(Space prefix, Markers markers, @Nullable Space.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JCL_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JCL_MARKER_WRAPPER));
        }
    }

    protected void afterSyntax(Jcl c, PrintOutputCapture<P> p) {
        this.afterSyntax(c.getMarkers(), p);
    }

    protected void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JCL_MARKER_WRAPPER));
        }
    }
}

