/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jcl.internal;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.openrewrite.FileAttributes;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.jcl.internal.grammar.JCLParser;
import org.openrewrite.jcl.internal.grammar.JCLParserBaseVisitor;
import org.openrewrite.jcl.markers.OmitFirstParam;
import org.openrewrite.jcl.tree.Expression;
import org.openrewrite.jcl.tree.Jcl;
import org.openrewrite.jcl.tree.JclContainer;
import org.openrewrite.jcl.tree.JclLeftPadded;
import org.openrewrite.jcl.tree.JclRightPadded;
import org.openrewrite.jcl.tree.Parameter;
import org.openrewrite.jcl.tree.Space;
import org.openrewrite.jcl.tree.Statement;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class JclParserVisitor
extends JCLParserBaseVisitor<Jcl> {
    private final Path path;
    @Nullable
    private final FileAttributes fileAttributes;
    private final String source;
    private final Charset charset;
    private final boolean charsetBomMarked;
    private int cursor = 0;
    private final Function<ParseTree, Space> commaDelim = ignored -> this.sourceBefore(",");
    private final Function<ParseTree, Space> noDelim = ignored -> Space.EMPTY;

    public JclParserVisitor(Path path, @Nullable FileAttributes fileAttributes, String source, Charset charset, boolean charsetBomMarked) {
        this.path = path;
        this.fileAttributes = fileAttributes;
        this.source = source;
        this.charset = charset;
        this.charsetBomMarked = charsetBomMarked;
    }

    public <T> T visit(ParseTree ... trees) {
        for (ParseTree tree : trees) {
            if (tree == null) continue;
            return (T)this.visit(tree);
        }
        throw new IllegalStateException("Expected one of the supplied trees to be non-null");
    }

    public <T> T visitNullable(@Nullable ParseTree tree) {
        if (tree == null) {
            return null;
        }
        return (T)super.visit(tree);
    }

    @Override
    public Jcl.CompilationUnit visitCompilationUnit(JCLParser.CompilationUnitContext ctx) {
        ArrayList<Statement> statements = new ArrayList<Statement>(ctx.statement().size());
        for (JCLParser.StatementContext statement : ctx.statement()) {
            statements.add((Statement)this.visitStatement(statement));
        }
        return new Jcl.CompilationUnit(Tree.randomId(), this.path, this.fileAttributes, Space.EMPTY, Markers.EMPTY, this.charset.name(), this.charsetBomMarked, null, statements, Space.build(this.source.substring(this.cursor), false));
    }

    @Override
    public Jcl visitDdStatement(JCLParser.DdStatementContext ctx) {
        return new Jcl.DataDefinitionStatement(Tree.randomId(), this.whitespace(), Markers.EMPTY, this.createIdentifier(ctx.DD().getText()), this.createParameters(ctx.parameter()));
    }

    @Override
    public Jcl visitExecStatement(JCLParser.ExecStatementContext ctx) {
        return new Jcl.ExecStatement(Tree.randomId(), this.whitespace(), Markers.EMPTY, this.createIdentifier(ctx.EXEC().getText()), this.createParameters(ctx.parameter()));
    }

    @Override
    public Jcl visitJclStatement(JCLParser.JclStatementContext ctx) {
        Space prefix = this.whitespace(true);
        this.skip("//");
        return new Jcl.JclStatement(Tree.randomId(), prefix, Markers.EMPTY, this.createIdentifier(StringUtils.isBlank((String)ctx.JCL_STATEMENT().getText().substring(2)) ? "" : ctx.JCL_STATEMENT().getText().substring(2)), (Jcl)this.visit(new ParseTree[]{ctx.jobStatement(), ctx.ddStatement(), ctx.execStatement(), ctx.outputStatement(), ctx.pendStatement(), ctx.procStatement(), ctx.setStatement(), ctx.xmitStatement()}));
    }

    @Override
    public Jcl visitJobStatement(JCLParser.JobStatementContext ctx) {
        return new Jcl.JobStatement(Tree.randomId(), this.whitespace(), Markers.EMPTY, this.createIdentifier(ctx.JOB().getText()), this.createParameters(ctx.parameter()));
    }

    @Override
    public Jcl visitName(JCLParser.NameContext ctx) {
        return new Jcl.JclName(Tree.randomId(), this.whitespace(), Markers.EMPTY, (Jcl.Identifier)this.visit(new ParseTree[]{ctx.PARAMETER(), ctx.NAME_FIELD()}), (Jcl.Parentheses)this.visitNullable((ParseTree)ctx.parameterParentheses()));
    }

    @Override
    public Jcl visitOutputStatement(JCLParser.OutputStatementContext ctx) {
        return new Jcl.JobStatement(Tree.randomId(), this.whitespace(), Markers.EMPTY, this.createIdentifier(ctx.OUTPUT().getText()), this.createParameters(ctx.parameter()));
    }

    @Override
    public Jcl visitParameter(JCLParser.ParameterContext ctx) {
        return (Jcl)super.visitParameter(ctx);
    }

    @Override
    public Jcl visitParameterAssignment(JCLParser.ParameterAssignmentContext ctx) {
        return new Jcl.Assignment(Tree.randomId(), this.whitespace(), Markers.EMPTY, (Expression)this.visit(new ParseTree[]{ctx.PARAMETER(), ctx.NAME_FIELD(), ctx.EXEC(), ctx.OUTPUT(), ctx.PROC()}), this.padLeft(this.sourceBefore("="), (Expression)this.visit((ParseTree)ctx.parameter())));
    }

    @Override
    public Jcl visitParameterLiteral(JCLParser.ParameterLiteralContext ctx) {
        Space prefix = this.whitespace();
        String value = ctx.getText();
        String sourceText = this.source.substring(ctx.start.getStartIndex(), ctx.stop.getStopIndex() + 1);
        this.skip(sourceText);
        return new Jcl.Literal(Tree.randomId(), prefix, Markers.EMPTY, value, sourceText);
    }

    @Override
    public Jcl visitParameterParentheses(JCLParser.ParameterParenthesesContext ctx) {
        Space prefix = this.whitespace();
        Markers markers = Markers.EMPTY;
        this.skip("(");
        ArrayList padded = new ArrayList(ctx.parameter().size());
        for (int i = 0; i < ctx.parameter().size(); ++i) {
            if (i == 0) {
                int saveCursor = this.cursor;
                this.whitespace();
                if (this.source.startsWith(",", this.cursor)) {
                    markers = markers.addIfAbsent((Marker)new OmitFirstParam(Tree.randomId()));
                    this.skip(",");
                } else {
                    this.cursor = saveCursor;
                }
            }
            Jcl tree = (Jcl)this.visit((ParseTree)ctx.parameter().get(i));
            padded.add(this.padRight(tree, i < ctx.parameter().size() - 1 ? this.sourceBefore(",") : this.sourceBefore(")")));
        }
        return new Jcl.Parentheses(Tree.randomId(), prefix, markers, padded);
    }

    @Override
    public Jcl visitPendStatement(JCLParser.PendStatementContext ctx) {
        return new Jcl.Pend(Tree.randomId(), this.whitespace(), Markers.EMPTY, this.createIdentifier(ctx.PEND().getText()));
    }

    @Override
    public Jcl visitProcStatement(JCLParser.ProcStatementContext ctx) {
        return new Jcl.ProcStatement(Tree.randomId(), this.whitespace(), Markers.EMPTY, this.createIdentifier(ctx.PROC().getText()), this.createParameters(ctx.parameter()));
    }

    @Override
    public Jcl visitSetStatement(JCLParser.SetStatementContext ctx) {
        return new Jcl.SetStatement(Tree.randomId(), this.whitespace(), Markers.EMPTY, this.createIdentifier(ctx.SET().getText()), this.createParameters(ctx.parameter()));
    }

    @Override
    public Jcl visitXmitStatement(JCLParser.XmitStatementContext ctx) {
        return new Jcl.XmitStatement(Tree.randomId(), this.whitespace(), Markers.EMPTY, this.createIdentifier(ctx.XMIT().getText()), this.createParameters(ctx.parameter()));
    }

    @Override
    public Jcl visitUnsupportedStatement(JCLParser.UnsupportedStatementContext ctx) {
        Space prefix = this.whitespace(true);
        String text = ctx.JES2() != null ? ctx.JES2().getText() + ctx.JES2_TEXT().getText() : ctx.UNSUPPORTED().getText() + ctx.UNSUPPORTED_TEXT().getText();
        this.skip(text);
        return new Jcl.Unsupported(Tree.randomId(), prefix, Markers.EMPTY, text);
    }

    public Jcl visitTerminal(TerminalNode node) {
        return this.createIdentifier(node.getText());
    }

    private Jcl.Identifier createIdentifier(@Nullable String name) {
        Space prefix = this.whitespace();
        this.skip(name);
        return new Jcl.Identifier(Tree.randomId(), prefix, Markers.EMPTY, name);
    }

    private JclContainer<Parameter> createParameters(List<JCLParser.ParameterContext> parameters) {
        Space before = this.whitespace();
        Markers markers = Markers.EMPTY;
        if (this.source.startsWith(",", this.cursor)) {
            this.skip(",");
            markers = markers.addIfAbsent((Marker)new OmitFirstParam(Tree.randomId()));
        }
        return JclContainer.build(before, parameters.isEmpty() ? Collections.emptyList() : this.convertAll(parameters, this.commaDelim, t -> Space.EMPTY), markers);
    }

    private <C extends Jcl, T extends ParseTree> List<C> convertAll(List<T> trees) {
        return this.convertAll(trees, t -> (Jcl)this.visit((ParseTree)t));
    }

    private <C, T extends ParseTree> List<C> convertAll(List<T> trees, Function<T, C> convert) {
        ArrayList<C> converted = new ArrayList<C>(trees.size());
        for (ParseTree tree : trees) {
            converted.add(convert.apply(tree));
        }
        return converted;
    }

    private <J2 extends Jcl> List<JclRightPadded<J2>> convertAll(List<JCLParser.ParameterContext> elements, Function<ParseTree, Space> innerSuffix, Function<ParseTree, Space> suffix) {
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList converted = new ArrayList(elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            ParseTree element = (ParseTree)elements.get(i);
            Jcl j = (Jcl)this.visit(element);
            Space after = i == elements.size() - 1 ? suffix.apply(element) : innerSuffix.apply(element);
            JclRightPadded<Jcl> rightPadded = this.padRight(j, after);
            converted.add(rightPadded);
        }
        return converted.isEmpty() ? Collections.emptyList() : converted;
    }

    private void skip(@Nullable String token) {
        if (token != null && this.source.startsWith(token, this.cursor)) {
            this.cursor += token.length();
        }
    }

    private Space whitespace(boolean skipContinuations) {
        boolean isContinued = false;
        if (!skipContinuations && this.source.startsWith("//", this.cursor)) {
            this.skip("//");
            isContinued = true;
        }
        int endIndex = JclParserVisitor.indexOfNextNonWhitespace(this.cursor, this.source);
        String prefix = this.source.substring(this.cursor, endIndex);
        this.cursor += prefix.length();
        return Space.build(prefix, isContinued);
    }

    private Space whitespace() {
        return this.whitespace(false);
    }

    private Space sourceBefore(String untilDelim) {
        Space prefix = this.whitespace();
        this.skip(untilDelim);
        return Space.build(prefix.getWhitespace(), prefix.isContinued());
    }

    public static int indexOfNextNonWhitespace(int cursor, String source) {
        int delimIndex;
        for (delimIndex = cursor; delimIndex < source.length() && Character.isWhitespace(source.substring(delimIndex, delimIndex + 1).charAt(0)); ++delimIndex) {
        }
        return delimIndex;
    }

    private <T> JclLeftPadded<T> padLeft(Space left, T tree) {
        return new JclLeftPadded<T>(left, tree, Markers.EMPTY);
    }

    private <T> JclRightPadded<T> padRight(T tree, @Nullable Space right) {
        return new JclRightPadded<T>(tree, right == null ? Space.EMPTY : right, Markers.EMPTY);
    }
}

