/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jcl;

import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.jcl.tree.Expression;
import org.openrewrite.jcl.tree.Jcl;
import org.openrewrite.jcl.tree.JclContainer;
import org.openrewrite.jcl.tree.JclLeftPadded;
import org.openrewrite.jcl.tree.JclRightPadded;
import org.openrewrite.jcl.tree.Name;
import org.openrewrite.jcl.tree.Space;
import org.openrewrite.jcl.tree.Statement;
import org.openrewrite.marker.Markers;

public class JclVisitor<P>
extends TreeVisitor<Jcl, P> {
    public Jcl visitCompilationUnit(Jcl.CompilationUnit compilationUnit, P p) {
        Jcl.CompilationUnit c = compilationUnit;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.COMPILATION_UNIT_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.withStatements(ListUtils.map(c.getStatements(), e -> (Statement)this.visitAndCast((Tree)e, p)));
        c = c.withEof(this.visitSpace(c.getEof(), Space.Location.COMPILATION_UNIT_EOF, p));
        return c;
    }

    public Jcl visitAssignment(Jcl.Assignment assignment, P p) {
        Jcl.Assignment a = assignment;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), Space.Location.ASSIGNMENT_PREFIX, p));
        a = a.withMarkers(this.visitMarkers(a.getMarkers(), p));
        a = a.withVariable((Expression)this.visitAndCast(a.getVariable(), p));
        a = a.getPadding().withAssignment(this.visitLeftPadded(a.getPadding().getAssignment(), JclLeftPadded.Location.ASSIGNMENT, p));
        return a;
    }

    public Jcl visitDataDefinitionStatement(Jcl.DataDefinitionStatement dataDefinitionStatement, P p) {
        Jcl.DataDefinitionStatement d = dataDefinitionStatement;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), Space.Location.DATA_DEFINITION_STATEMENT_PREFIX, p));
        d = d.withMarkers(this.visitMarkers(d.getMarkers(), p));
        d = d.withName((Name)this.visitAndCast(d.getName(), p));
        d = d.getPadding().withParameters(this.visitContainer(d.getPadding().getParameters(), JclContainer.Location.PARAMETERS, p));
        return d;
    }

    public Jcl visitExecStatement(Jcl.ExecStatement execStatement, P p) {
        Jcl.ExecStatement e = execStatement;
        e = e.withPrefix(this.visitSpace(e.getPrefix(), Space.Location.EXEC_STATEMENT_PREFIX, p));
        e = e.withMarkers(this.visitMarkers(e.getMarkers(), p));
        e = e.withName((Name)this.visitAndCast(e.getName(), p));
        e = e.getPadding().withParameters(this.visitContainer(e.getPadding().getParameters(), JclContainer.Location.PARAMETERS, p));
        return e;
    }

    public Jcl visitIdentifier(Jcl.Identifier identifier, P p) {
        Jcl.Identifier i = identifier;
        i = i.withPrefix(this.visitSpace(i.getPrefix(), Space.Location.IDENTIFIER_PREFIX, p));
        i = i.withMarkers(this.visitMarkers(i.getMarkers(), p));
        return i;
    }

    public Jcl visitJclName(Jcl.JclName jclName, P p) {
        Jcl.JclName j = jclName;
        j = j.withPrefix(this.visitSpace(j.getPrefix(), Space.Location.JCL_NAME_PREFIX, p));
        j = j.withMarkers(this.visitMarkers(j.getMarkers(), p));
        return j;
    }

    public Jcl visitJclStatement(Jcl.JclStatement jclStatement, P p) {
        Jcl.JclStatement j = jclStatement;
        j = j.withPrefix(this.visitSpace(j.getPrefix(), Space.Location.JCL_STATEMENT_PREFIX, p));
        j = j.withMarkers(this.visitMarkers(j.getMarkers(), p));
        j = j.withName((Name)this.visitAndCast(j.getName(), p));
        j = j.withStatement((Jcl)this.visitAndCast(j.getStatement(), p));
        return j;
    }

    public Jcl visitJobStatement(Jcl.JobStatement jobStatement, P p) {
        Jcl.JobStatement j = jobStatement;
        j = j.withPrefix(this.visitSpace(j.getPrefix(), Space.Location.JOB_STATEMENT_PREFIX, p));
        j = j.withMarkers(this.visitMarkers(j.getMarkers(), p));
        j = j.withName((Name)this.visitAndCast(j.getName(), p));
        j = j.getPadding().withParameters(this.visitContainer(j.getPadding().getParameters(), JclContainer.Location.PARAMETERS, p));
        return j;
    }

    public Jcl visitLiteral(Jcl.Literal literal, P p) {
        Jcl.Literal l = literal;
        l = l.withPrefix(this.visitSpace(l.getPrefix(), Space.Location.LITERAL_PREFIX, p));
        l = l.withMarkers(this.visitMarkers(l.getMarkers(), p));
        return l;
    }

    public Jcl visitOutputStatement(Jcl.OutputStatement outputStatement, P p) {
        Jcl.OutputStatement o = outputStatement;
        o = o.withPrefix(this.visitSpace(o.getPrefix(), Space.Location.OUTPUT_STATEMENT_PREFIX, p));
        o = o.withMarkers(this.visitMarkers(o.getMarkers(), p));
        o = o.withName((Name)this.visitAndCast(o.getName(), p));
        o = o.getPadding().withParameters(this.visitContainer(o.getPadding().getParameters(), JclContainer.Location.PARAMETERS, p));
        return o;
    }

    public <T extends Jcl> Jcl visitParentheses(Jcl.Parentheses<T> parentheses, P p) {
        Jcl pa = parentheses;
        pa = ((Jcl.Parentheses)pa).withPrefix(this.visitSpace(((Jcl.Parentheses)pa).getPrefix(), Space.Location.PARENTHESES_PREFIX, p));
        pa = ((Jcl.Parentheses)pa).getPadding().withTrees(ListUtils.map(((Jcl.Parentheses)pa).getPadding().getTrees(), t -> this.visitRightPadded((JclRightPadded)t, JclRightPadded.Location.PARENTHESES, p)));
        pa = ((Jcl.Parentheses)pa).withMarkers(this.visitMarkers(((Jcl.Parentheses)pa).getMarkers(), p));
        return pa;
    }

    public Jcl visitPend(Jcl.Pend pend, P p) {
        Jcl.Pend pe = pend;
        pe = pe.withPrefix(this.visitSpace(pe.getPrefix(), Space.Location.PEND_PREFIX, p));
        pe = pe.withMarkers(this.visitMarkers(pe.getMarkers(), p));
        return pe;
    }

    public Jcl visitProcStatement(Jcl.ProcStatement procStatement, P p) {
        Jcl.ProcStatement pr = procStatement;
        pr = pr.withPrefix(this.visitSpace(pr.getPrefix(), Space.Location.PROC_STATEMENT_PREFIX, p));
        pr = pr.withMarkers(this.visitMarkers(pr.getMarkers(), p));
        pr = pr.withName((Name)this.visitAndCast(pr.getName(), p));
        pr = pr.getPadding().withParameters(this.visitContainer(pr.getPadding().getParameters(), JclContainer.Location.PARAMETERS, p));
        return pr;
    }

    public Jcl visitSetStatement(Jcl.SetStatement setStatement, P p) {
        Jcl.SetStatement s = setStatement;
        s = s.withPrefix(this.visitSpace(s.getPrefix(), Space.Location.SET_STATEMENT_PREFIX, p));
        s = s.withMarkers(this.visitMarkers(s.getMarkers(), p));
        s = s.withName((Name)this.visitAndCast(s.getName(), p));
        s = s.getPadding().withParameters(this.visitContainer(s.getPadding().getParameters(), JclContainer.Location.PARAMETERS, p));
        return s;
    }

    public Jcl visitXmitStatement(Jcl.XmitStatement xmitStatement, P p) {
        Jcl.XmitStatement x = xmitStatement;
        x = x.withPrefix(this.visitSpace(x.getPrefix(), Space.Location.XMIT_STATEMENT_PREFIX, p));
        x = x.withMarkers(this.visitMarkers(x.getMarkers(), p));
        x = x.withName((Name)this.visitAndCast(x.getName(), p));
        x = x.getPadding().withParameters(this.visitContainer(x.getPadding().getParameters(), JclContainer.Location.PARAMETERS, p));
        return x;
    }

    public Jcl visitUnsupported(Jcl.Unsupported unsupported, P p) {
        Jcl.Unsupported u = unsupported;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), Space.Location.UNSUPPORTED_PREFIX, p));
        u = u.withMarkers(this.visitMarkers(u.getMarkers(), p));
        return u;
    }

    public Space visitSpace(Space space, Space.Location location, P p) {
        return space;
    }

    public <J2 extends Jcl> JclContainer<J2> visitContainer(@Nullable JclContainer<J2> container, JclContainer.Location loc, P p) {
        if (container == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), container));
        Space before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), p);
        List js = ListUtils.map(container.getPadding().getElements(), t -> this.visitRightPadded((JclRightPadded)t, loc.getElementLocation(), p));
        this.setCursor(this.getCursor().getParent());
        return js == container.getPadding().getElements() && before == container.getBefore() ? container : JclContainer.build(before, js, container.getMarkers());
    }

    public <T> JclLeftPadded<T> visitLeftPadded(@Nullable JclLeftPadded<T> left, JclLeftPadded.Location loc, P p) {
        if (left == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), left));
        Space before = this.visitSpace(left.getBefore(), loc.getBeforeLocation(), p);
        Object t = left.getElement();
        if (t instanceof Jcl) {
            t = this.visitAndCast((Jcl)left.getElement(), p);
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            if (left.getElement() == null && before == left.getBefore()) {
                return left;
            }
            return null;
        }
        return before == left.getBefore() && t == left.getElement() ? left : new JclLeftPadded<T>(before, t, left.getMarkers());
    }

    public <T> JclRightPadded<T> visitRightPadded(@Nullable JclRightPadded<T> right, JclRightPadded.Location loc, P p) {
        if (right == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), right));
        Object t = right.getElement();
        if (t instanceof Jcl) {
            t = this.visitAndCast((Jcl)right.getElement(), p);
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            return null;
        }
        Space after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
        Markers markers = this.visitMarkers(right.getMarkers(), p);
        return after == right.getAfter() && t == right.getElement() && markers == right.getMarkers() ? right : new JclRightPadded<T>(t, after, markers);
    }
}

