/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol.tree;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.cobol.internal.CobolPreprocessorSourcePrinter;
import org.openrewrite.cobol.internal.CobolSourcePrinter;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.CobolPreprocessor;
import org.openrewrite.cobol.tree.ColumnArea;
import org.openrewrite.cobol.tree.CommentArea;
import org.openrewrite.cobol.tree.IndicatorArea;
import org.openrewrite.cobol.tree.SequenceArea;
import org.openrewrite.cobol.tree.Space;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@c")
public final class Continuation {
    private final Markers markers;
    private final Map<Integer, List<ColumnArea>> continuations;

    public <P> void printContinuation(CobolPreprocessorSourcePrinter<P> sourcePrinter, Cursor cursor, CobolPreprocessor.Word word, boolean printColumns, PrintOutputCapture<P> p) {
        for (Marker marker : this.getMarkers().getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(cursor, (Object)marker), CobolSourcePrinter.COBOL_MARKER_WRAPPER));
        }
        if (this.continuations.containsKey(0)) {
            for (ColumnArea columnArea : this.continuations.get(0)) {
                if (columnArea instanceof SequenceArea) {
                    columnArea.printColumnArea(sourcePrinter, cursor, printColumns, p);
                    continue;
                }
                if (!(columnArea instanceof IndicatorArea)) continue;
                columnArea.printColumnArea(sourcePrinter, cursor, printColumns, p);
            }
        }
        sourcePrinter.visitSpace(word.getPrefix(), Space.Location.CONTINUATION_PREFIX, p);
        char[] charArray = word.getCobolWord().getWord().toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (i != 0 && this.continuations.containsKey(i)) {
                for (ColumnArea columnArea : this.continuations.get(i)) {
                    columnArea.printColumnArea(sourcePrinter, cursor, printColumns, p);
                }
            }
            char c = charArray[i];
            p.append(c);
        }
        List lastColumnAreas = this.continuations.entrySet().stream().filter(it -> (Integer)it.getKey() > word.getCobolWord().getWord().length()).map(Map.Entry::getValue).collect(Collectors.toList());
        if (!lastColumnAreas.isEmpty()) {
            List columnAreas = (List)lastColumnAreas.get(0);
            for (ColumnArea columnArea : columnAreas) {
                if (!(columnArea instanceof CommentArea)) continue;
                columnArea.printColumnArea(sourcePrinter, cursor, printColumns, p);
            }
        }
        for (Marker marker : this.getMarkers().getMarkers()) {
            p.out.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(cursor, (Object)marker), CobolSourcePrinter.COBOL_MARKER_WRAPPER));
        }
    }

    public <P> void printContinuation(CobolSourcePrinter<P> sourcePrinter, Cursor cursor, Cobol.Word word, boolean printColumns, PrintOutputCapture<P> p) {
        for (Marker marker : this.markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(cursor, (Object)marker), CobolSourcePrinter.COBOL_MARKER_WRAPPER));
        }
        if (this.continuations.containsKey(0)) {
            for (ColumnArea columnArea : this.continuations.get(0)) {
                if (columnArea instanceof SequenceArea) {
                    columnArea.printColumnArea(sourcePrinter, cursor, printColumns, p);
                    continue;
                }
                if (!(columnArea instanceof IndicatorArea)) continue;
                columnArea.printColumnArea(sourcePrinter, cursor, printColumns, p);
            }
        }
        sourcePrinter.visitSpace(word.getPrefix(), Space.Location.CONTINUATION_PREFIX, p);
        char[] charArray = word.getWord().toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (i != 0 && this.continuations.containsKey(i)) {
                for (ColumnArea columnArea : this.continuations.get(i)) {
                    columnArea.printColumnArea(sourcePrinter, cursor, printColumns, p);
                }
            }
            char c = charArray[i];
            p.append(c);
        }
        List lastColumnAreas = this.continuations.entrySet().stream().filter(it -> (Integer)it.getKey() > word.getWord().length()).map(Map.Entry::getValue).collect(Collectors.toList());
        if (!lastColumnAreas.isEmpty()) {
            List columnAreas = (List)lastColumnAreas.get(0);
            for (ColumnArea columnArea : columnAreas) {
                if (!(columnArea instanceof CommentArea)) continue;
                columnArea.printColumnArea(sourcePrinter, cursor, printColumns, p);
            }
        }
        for (Marker marker : this.markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(cursor, (Object)marker), CobolSourcePrinter.COBOL_MARKER_WRAPPER));
        }
    }

    public Continuation(Markers markers, Map<Integer, List<ColumnArea>> continuations) {
        this.markers = markers;
        this.continuations = continuations;
    }

    public Markers getMarkers() {
        return this.markers;
    }

    public Map<Integer, List<ColumnArea>> getContinuations() {
        return this.continuations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Continuation)) {
            return false;
        }
        Continuation other = (Continuation)o;
        Markers this$markers = this.getMarkers();
        Markers other$markers = other.getMarkers();
        if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
            return false;
        }
        Map<Integer, List<ColumnArea>> this$continuations = this.getContinuations();
        Map<Integer, List<ColumnArea>> other$continuations = other.getContinuations();
        return !(this$continuations == null ? other$continuations != null : !((Object)this$continuations).equals(other$continuations));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Markers $markers = this.getMarkers();
        result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
        Map<Integer, List<ColumnArea>> $continuations = this.getContinuations();
        result = result * 59 + ($continuations == null ? 43 : ((Object)$continuations).hashCode());
        return result;
    }

    public String toString() {
        return "Continuation(markers=" + this.getMarkers() + ", continuations=" + this.getContinuations() + ")";
    }

    public Continuation withMarkers(Markers markers) {
        return this.markers == markers ? this : new Continuation(markers, this.continuations);
    }

    public Continuation withContinuations(Map<Integer, List<ColumnArea>> continuations) {
        return this.continuations == continuations ? this : new Continuation(this.markers, continuations);
    }
}

